/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.cosmetic.PlayerHeadIcon;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.HeadUtils;

public class SelectTerritoryHeadMenu
extends IteratorGUI {
    private final TerritoryData territoryData;

    protected SelectTerritoryHeadMenu(Player player, TerritoryData territoryData) {
        super(player, Lang.HEADER_SELECT_ICON, 4);
        this.territoryData = territoryData;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getHeads(), p -> this.territoryData.openMainMenu(this.player));
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getHeads() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (String playerID : this.territoryData.getPlayerIDList()) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(playerID));
            ItemStack playerHead = HeadUtils.getPlayerHead(offlinePlayer);
            guiItems.add(this.iconManager.get(playerHead).setName(offlinePlayer.getName()).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_SELECT).setAction(action -> {
                this.territoryData.setIcon(new PlayerHeadIcon(offlinePlayer.getUniqueId().toString()));
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.MINOR_GOOD);
                this.territoryData.openMainMenu(this.player);
            }).asGuiItem(this.player, this.langType));
        }
        return guiItems;
    }
}

