/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.dataclass.RankData;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.service.requirements.RankDifferenceRequirement;
import org.leralix.tan.gui.service.requirements.RankPermissionRequirement;
import org.leralix.tan.gui.user.ranks.RankManagerMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.PlayerChatListenerStorage;
import org.leralix.tan.listeners.chat.events.CreateRank;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class TerritoryRanksMenu
extends IteratorGUI {
    private final TerritoryData territoryData;

    public TerritoryRanksMenu(Player player, TerritoryData territoryData) {
        super(player, Lang.HEADER_TERRITORY_RANKS, 4);
        this.territoryData = territoryData;
    }

    @Override
    public void open() {
        GuiUtil.createIterator(this.gui, this.getRanks(), this.page, this.player, p -> this.territoryData.openMainMenu(this.player), p -> this.nextPage(), p -> this.previousPage());
        this.gui.setItem(4, 5, this.getCreateNewRoleButton());
        this.gui.open((HumanEntity)this.player);
    }

    private GuiItem getCreateNewRoleButton() {
        int nbRanks = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("townMaxRank", 8);
        return this.iconManager.get(IconKey.NEW_RANK_ICON).setName(Lang.GUI_TOWN_MEMBERS_ADD_NEW_ROLES.get(this.tanPlayer)).setDescription(Lang.GUI_TOWN_MEMBERS_ADD_NEW_ROLES_DESC1.get(Integer.toString(nbRanks))).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_CREATE).setAction(event -> {
            event.setCancelled(true);
            if (!this.territoryData.doesPlayerHavePermission(this.tanPlayer, RolePermission.CREATE_RANK)) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer));
                return;
            }
            if (this.territoryData.getNumberOfRank() >= nbRanks) {
                TanChatUtils.message(this.player, Lang.TOWN_RANK_CAP_REACHED.get(this.tanPlayer));
                return;
            }
            TanChatUtils.message(this.player, Lang.WRITE_IN_CHAT_NEW_ROLE_NAME.get(this.tanPlayer));
            PlayerChatListenerStorage.register(this.player, new CreateRank(this.territoryData, p -> new TerritoryRanksMenu(this.player, this.territoryData).open()));
        }).asGuiItem(this.player, this.langType);
    }

    private List<GuiItem> getRanks() {
        ArrayList<GuiItem> res = new ArrayList<GuiItem>();
        for (RankData rank : this.territoryData.getAllRanksSorted()) {
            res.add(this.getSingleRankButton(rank));
        }
        return res;
    }

    private GuiItem getSingleRankButton(RankData rank) {
        return this.iconManager.get(rank.getRankIcon()).setName(rank.getColoredName()).setDescription(Lang.GUI_RANK_NUMBER_PLAYER_WITH_ROLE.get(Integer.toString(rank.getNumberOfPlayer()))).setRequirements(new RankPermissionRequirement(this.territoryData, this.tanPlayer, RolePermission.MANAGE_RANKS), new RankDifferenceRequirement(this.territoryData, this.tanPlayer, rank)).setAction(action -> {
            if (this.territoryData.getRank(this.tanPlayer).getLevel() <= rank.getLevel() && !this.territoryData.isLeader(this.tanPlayer)) {
                TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION_RANK_DIFFERENCE.get(this.langType, new String[0]));
                return;
            }
            new RankManagerMenu(this.player, this.territoryData, rank).open();
        }).asGuiItem(this.player, this.langType);
    }
}

