/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.territory.AttackMenu;
import org.leralix.tan.gui.user.war.WarMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.WarStorage;
import org.leralix.tan.war.War;

public class WarsMenu
extends IteratorGUI {
    private final TerritoryData territoryData;

    public WarsMenu(Player player, TerritoryData territoryData) {
        super(player, "War Menu", 4);
        this.territoryData = territoryData;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getWars(this.territoryData), p -> this.territoryData.openMainMenu(this.player));
        this.gui.open((HumanEntity)this.player);
    }

    public List<GuiItem> getWars(TerritoryData territoryData) {
        List<War> wars = WarStorage.getInstance().getWarsOfTerritory(territoryData);
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (War war : wars) {
            guiItems.add(this.iconManager.get(war.getIcon()).setName(war.getName()).setDescription(Lang.ATTACK_ICON_DESC_1.get(war.getMainAttacker().getColoredName()), Lang.ATTACK_ICON_DESC_2.get(war.getMainDefender().getColoredName())).setAction(event -> new WarMenu(this.player, territoryData, war)).asGuiItem(this.player, this.langType));
        }
        this.gui.setItem(4, 4, this.getAttackButton(territoryData));
        return guiItems;
    }

    @NotNull
    private GuiItem getAttackButton(TerritoryData territoryData) {
        return this.iconManager.get(new ItemStack(Material.BOW)).setName("Open Attacks").setAction(p -> new AttackMenu(this.player, territoryData)).asGuiItem(this.player, this.langType);
    }
}

