/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory.hierarchy;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.legacy.PlayerGUI;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.HeadUtils;
import org.leralix.tan.utils.text.TanChatUtils;

public class VassalsMenu
extends IteratorGUI {
    private final TerritoryData territoryData;

    public VassalsMenu(Player player, TerritoryData territoryData) {
        super(player, Lang.HEADER_VASSALS.get(player), 4);
        this.territoryData = territoryData;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getVassals(), p -> PlayerGUI.openHierarchyMenu(this.player, this.territoryData));
        this.gui.setItem(4, 3, this.getAddVassalButton());
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getAddVassalButton() {
        ItemStack addTown = HeadUtils.makeSkullB64(Lang.GUI_INVITE_TOWN_TO_REGION.get(this.tanPlayer), "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWZmMzE0MzFkNjQ1ODdmZjZlZjk4YzA2NzU4MTA2ODFmOGMxM2JmOTZmNTFkOWNiMDdlZDc4NTJiMmZmZDEifX19");
        return ItemBuilder.from(addTown).asGuiItem(event -> {
            event.setCancelled(true);
            if (!this.territoryData.doesPlayerHavePermission(this.tanPlayer, RolePermission.TOWN_ADMINISTRATOR)) {
                TanChatUtils.message(this.player, Lang.GUI_NEED_TO_BE_LEADER_OF_REGION.get(this.tanPlayer));
                return;
            }
            PlayerGUI.openAddVassal(this.player, this.territoryData, 0);
        });
    }

    private List<GuiItem> getVassals() {
        ArrayList<GuiItem> res = new ArrayList<GuiItem>();
        for (TerritoryData vassal : this.territoryData.getVassals()) {
            GuiItem vassalButton = this.iconManager.get(vassal.getIcon()).setName(vassal.getColoredName()).setDescription(new FilledLang[0]).setDescription(Lang.GUI_TOWN_INFO_DESC0.get(vassal.getDescription()), Lang.GUI_TOWN_INFO_DESC1.get(vassal.getLeaderName()), Lang.GUI_TOWN_INFO_DESC2.get(Integer.toString(vassal.getPlayerIDList().size())), Lang.GUI_TOWN_INFO_DESC3.get(Integer.toString(vassal.getNumberOfClaimedChunk()))).setClickToAcceptMessage(Lang.GUI_GENERIC_RIGHT_CLICK_TO_REMOVE).setAction(action -> {
                if (!action.isRightClick()) {
                    return;
                }
                if (vassal.isCapital()) {
                    TanChatUtils.message(this.player, Lang.CANT_KICK_REGIONAL_CAPITAL.get(this.tanPlayer, vassal.getName()));
                    return;
                }
                PlayerGUI.openConfirmMenu(this.player, "", confirmAction -> {
                    this.territoryData.broadcastMessageWithSound(Lang.GUI_REGION_KICK_TOWN_BROADCAST.get(vassal.getName()), SoundEnum.BAD);
                    vassal.removeOverlord();
                    this.player.closeInventory();
                }, previousAction -> this.open());
            }).asGuiItem(this.player, this.langType);
            res.add(vassalButton);
        }
        return res;
    }
}

