/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.listeners.interact.events;

import java.util.function.Consumer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerInteractEvent;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.chunk.TownClaimedChunk;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.listeners.interact.ListenerState;
import org.leralix.tan.listeners.interact.RightClickListenerEvent;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;

public class ChangeCapital
extends RightClickListenerEvent {
    private final TownData townData;
    private final Consumer<Player> fallbackGui;

    public ChangeCapital(TownData townData, Consumer<Player> fallBackGui) {
        this.townData = townData;
        this.fallbackGui = fallBackGui;
    }

    @Override
    public ListenerState execute(PlayerInteractEvent event) {
        Block block = event.getClickedBlock();
        if (block == null) {
            return ListenerState.CONTINUE;
        }
        ClaimedChunk2 claimedChunk2 = NewClaimedChunkStorage.getInstance().get(block.getChunk());
        if (claimedChunk2 instanceof TownClaimedChunk) {
            TownClaimedChunk townClaimedChunk = (TownClaimedChunk)claimedChunk2;
            if (this.townData.getID().equals(townClaimedChunk.getOwnerID())) {
                this.townData.setCapitalLocation(claimedChunk2.getVector2D());
                Player player = event.getPlayer();
                this.openGui(this.fallbackGui, player);
                SoundUtil.playSound((Player)player, (SoundEnum)SoundEnum.MINOR_GOOD);
                return ListenerState.SUCCESS;
            }
        }
        return ListenerState.FAILURE;
    }
}

