/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.impl;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.leralix.lib.position.Vector3D;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.FortStorage;
import org.leralix.tan.war.fort.Fort;
import org.leralix.tan.war.fort.FortData;

public class FortDataStorage
extends FortStorage {
    int newFortID = 0;
    Map<String, FortData> forts = new HashMap<String, FortData>();

    public FortDataStorage() {
        this.load();
    }

    @Override
    public List<Fort> getOccupiedFort(TerritoryData territoryData) {
        ArrayList<Fort> res = new ArrayList<Fort>();
        for (String fortID : territoryData.getOccupiedFortIds()) {
            FortData fort = this.forts.get(fortID);
            if (fort == null) continue;
            res.add(fort);
        }
        return res;
    }

    @Override
    public List<Fort> getOwnedFort(TerritoryData territoryData) {
        ArrayList<Fort> res = new ArrayList<Fort>();
        for (String fortID : territoryData.getOwnedFortIDs()) {
            FortData fort = this.forts.get(fortID);
            if (fort == null) continue;
            res.add(fort);
        }
        return res;
    }

    @Override
    public List<Fort> getAllControlledFort(TerritoryData territoryData) {
        ArrayList<Fort> allForts = new ArrayList<Fort>(this.getOccupiedFort(territoryData));
        for (Fort fort : this.getOwnedFort(territoryData)) {
            if (fort.isOccupied()) continue;
            allForts.add(fort);
        }
        return allForts;
    }

    @Override
    public List<Fort> getForts() {
        return new ArrayList<Fort>(this.forts.values());
    }

    @Override
    public Fort getFort(String fortID) {
        return this.forts.get(fortID);
    }

    @Override
    public Fort register(Vector3D position, TerritoryData owningTerritory) {
        FortData fort = new FortData("F" + this.newFortID, position, Lang.DEFAULT_FORT_NAME.get(Lang.getServerLang(), Integer.toString(this.newFortID)), owningTerritory);
        this.forts.put(fort.getID(), fort);
        this.save();
        return fort;
    }

    @Override
    public void delete(String fortID) {
        Fort fort = this.getFort(fortID);
        if (fort == null) {
            return;
        }
        TerritoryData owner = fort.getOwner();
        owner.removeFort(fortID);
        this.forts.remove(fortID);
        this.save();
    }

    public void load() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File file = new File(TownsAndNations.getPlugin().getDataFolder().getAbsolutePath() + "/storage/json/Forts.json");
        if (file.exists()) {
            FileReader reader;
            try {
                reader = new FileReader(file);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
            Type type = new TypeToken<HashMap<String, FortData>>(){}.getType();
            this.forts = (Map)gson.fromJson((Reader)reader, type);
            int id = 0;
            for (String ids : this.forts.keySet()) {
                int newID = Integer.parseInt(ids.substring(1));
                if (newID <= id) continue;
                id = newID;
            }
            this.newFortID = id + 1;
        }
    }

    @Override
    public void save() {
        FileWriter writer;
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        File file = new File(TownsAndNations.getPlugin().getDataFolder().getAbsolutePath() + "/storage/json/Forts.json");
        file.getParentFile().getParentFile().mkdir();
        file.getParentFile().mkdir();
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    throw new FileNotFoundException("Could not create file: " + file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            writer = new FileWriter(file, false);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        gson.toJson(this.forts, (Appendable)writer);
        try {
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            ((Writer)writer).close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

