/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.stored;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.TownsAndNations;

public abstract class JsonStorage<T> {
    protected final File file;
    protected Map<String, T> dataMap;
    protected final Gson gson;
    private final Type type;
    private static final String NEW_FILE_FOLDER = "storage/json";

    protected JsonStorage(String fileName, Type type, Gson gson) {
        this.file = JsonStorage.getFile(fileName);
        this.type = type;
        this.gson = gson;
        this.load();
    }

    @NotNull
    static File getFile(String fileName) {
        File pluginFolder = TownsAndNations.getPlugin().getDataFolder();
        File oldFile = new File(pluginFolder, fileName);
        File newFolder = new File(pluginFolder, NEW_FILE_FOLDER);
        File newFile = new File(newFolder, fileName);
        if (oldFile.exists() && !newFile.exists()) {
            try {
                Files.createDirectories(newFolder.toPath(), new FileAttribute[0]);
                Files.move(oldFile.toPath(), newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                Bukkit.getLogger().info("Moved " + fileName + " to new storage location: " + newFile.getAbsolutePath());
            }
            catch (IOException e) {
                Bukkit.getLogger().severe("Failed to move " + fileName + " to new storage location. : " + e.getMessage());
            }
        }
        return newFile;
    }

    protected void load() {
        if (!this.file.exists()) {
            this.dataMap = new LinkedHashMap<String, T>();
        } else {
            try (FileReader reader = new FileReader(this.file);){
                this.dataMap = (Map)this.gson.fromJson((Reader)reader, this.type);
            }
            catch (IOException e) {
                TownsAndNations.getPlugin().getLogger().severe("Error loading " + this.file.getName());
            }
        }
    }

    public void save() {
        try {
            Files.createDirectories(this.file.getParentFile().toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        File tempFile = new File(this.file.getParent(), this.file.getName() + ".tmp");
        try (FileWriter writer = new FileWriter(tempFile, false);){
            this.gson.toJson(this.dataMap, this.type, writer);
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("Error saving " + this.file.getName() + " : " + e.getMessage());
            return;
        }
        try {
            Files.move(tempFile.toPath(), this.file.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            Bukkit.getLogger().severe("Failed to replace old file with new one: " + this.file.getName() + " : " + e.getMessage());
        }
    }

    public Map<String, T> getAll() {
        return this.dataMap;
    }

    public T get(String id) {
        return this.dataMap.get(id);
    }

    public void delete(String id) {
        this.dataMap.remove(id);
        this.save();
    }

    public void put(String id, T obj) {
        this.dataMap.put(id, obj);
        this.save();
    }

    public abstract void reset();
}

