/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.stored;

import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import java.time.Instant;
import java.util.HashMap;
import org.leralix.tan.dataclass.ActiveTruce;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.storage.stored.JsonStorage;

public class TruceStorage
extends JsonStorage<HashMap<String, ActiveTruce>> {
    private static TruceStorage instance;

    protected TruceStorage() {
        super("TAN - Truce.json", new TypeToken<HashMap<String, HashMap<String, ActiveTruce>>>(){}.getType(), new GsonBuilder().setPrettyPrinting().create());
    }

    public static TruceStorage getInstance() {
        if (instance == null) {
            instance = new TruceStorage();
        }
        return instance;
    }

    @Override
    public void reset() {
        this.dataMap.clear();
    }

    public void add(ActiveTruce activeTruce) {
        String id1 = activeTruce.getTerritoryID1();
        String id2 = activeTruce.getTerritoryID2();
        this.dataMap.computeIfAbsent(id1, k -> new HashMap()).put(id2, activeTruce);
        this.dataMap.computeIfAbsent(id2, k -> new HashMap()).put(id1, activeTruce);
    }

    public long getRemainingTruce(TerritoryData territoryData1, TerritoryData territoryData2) {
        String id1 = territoryData1.getID();
        String id2 = territoryData2.getID();
        ActiveTruce truce = (ActiveTruce)this.dataMap.getOrDefault(id1, new HashMap()).get(id2);
        if (truce == null) {
            return 0L;
        }
        long remaining = truce.getEndOfTruce() - Instant.now().toEpochMilli();
        long remainingInHours = remaining / 1000L / 60L / 60L;
        return Math.max(0L, remainingInHours);
    }
}

