/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.upgrade;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.dataclass.territory.RegionData;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.service.requirements.model.AnyLogScope;
import org.leralix.tan.gui.service.requirements.model.AnyPlankScope;
import org.leralix.tan.gui.service.requirements.model.AnyStoneScope;
import org.leralix.tan.gui.service.requirements.model.AnyWoodScope;
import org.leralix.tan.gui.service.requirements.model.MaterialScope;
import org.leralix.tan.gui.service.requirements.upgrade.ItemRequirementBuilder;
import org.leralix.tan.gui.service.requirements.upgrade.LevelUpgradeRequirement;
import org.leralix.tan.gui.service.requirements.upgrade.OtherUpgradeRequirementBuilder;
import org.leralix.tan.gui.service.requirements.upgrade.UpgradeCostRequirement;
import org.leralix.tan.gui.service.requirements.upgrade.UpgradeRequirement;
import org.leralix.tan.upgrade.Upgrade;
import org.leralix.tan.upgrade.rewards.IndividualStat;
import org.leralix.tan.upgrade.rewards.StatsType;
import org.leralix.tan.upgrade.rewards.bool.EnableMobBan;
import org.leralix.tan.upgrade.rewards.bool.EnableTownSpawn;
import org.leralix.tan.upgrade.rewards.list.BiomeStat;
import org.leralix.tan.upgrade.rewards.list.PermissionList;
import org.leralix.tan.upgrade.rewards.numeric.ChunkCap;
import org.leralix.tan.upgrade.rewards.numeric.ChunkCost;
import org.leralix.tan.upgrade.rewards.numeric.LandmarkCap;
import org.leralix.tan.upgrade.rewards.numeric.PropertyCap;
import org.leralix.tan.upgrade.rewards.numeric.TownPlayerCap;
import org.leralix.tan.upgrade.rewards.percentage.LandmarkBonus;

public class NewUpgradeStorage {
    private final Map<String, Upgrade> townUpgrades = new HashMap<String, Upgrade>();
    private final Map<String, Upgrade> regionUpgrades = new HashMap<String, Upgrade>();

    public NewUpgradeStorage() {
        FileConfiguration upgradeConfig = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.UPGRADE);
        this.setUpUpgrades(this.townUpgrades, upgradeConfig.getConfigurationSection("upgrades"));
        this.setUpUpgrades(this.regionUpgrades, upgradeConfig.getConfigurationSection("region_upgrades"));
    }

    private void setUpUpgrades(Map<String, Upgrade> upgradeMap, ConfigurationSection upgradesSection) {
        if (upgradesSection != null) {
            for (String key : upgradesSection.getKeys(false)) {
                ConfigurationSection resourcesSection;
                int col = upgradesSection.getInt(key + ".col");
                int row = upgradesSection.getInt(key + ".row");
                String itemCode = upgradesSection.getString(key + ".itemCode", "BARRIER");
                Material icon = Material.valueOf((String)itemCode.toUpperCase());
                int maxLevel = upgradesSection.getInt(key + ".maxLevel");
                ArrayList<UpgradeRequirement> newPrerequisites = new ArrayList<UpgradeRequirement>();
                List cost = upgradesSection.getIntegerList(key + ".cost");
                newPrerequisites.add(new UpgradeCostRequirement(cost));
                ConfigurationSection prerequisiteSection = upgradesSection.getConfigurationSection(key + ".prerequisites");
                if (prerequisiteSection != null) {
                    for (Object prerequisiteKey : prerequisiteSection.getKeys(false)) {
                        int requiredLevel = prerequisiteSection.getInt((String)prerequisiteKey);
                        if (((String)prerequisiteKey).equals("TOWN_LEVEL")) {
                            newPrerequisites.add(new LevelUpgradeRequirement(requiredLevel));
                            continue;
                        }
                        newPrerequisites.add(new OtherUpgradeRequirementBuilder((String)prerequisiteKey, requiredLevel));
                    }
                }
                if ((resourcesSection = upgradesSection.getConfigurationSection(key + ".resources")) != null) {
                    Object prerequisiteKey;
                    prerequisiteKey = resourcesSection.getKeys(false).iterator();
                    block38: while (prerequisiteKey.hasNext()) {
                        String ressourcesKey = (String)prerequisiteKey.next();
                        int number = resourcesSection.getInt(ressourcesKey);
                        switch (ressourcesKey) {
                            case "ANY_WOOD": {
                                newPrerequisites.add(new ItemRequirementBuilder(new AnyWoodScope(), number));
                                continue block38;
                            }
                            case "ANY_LOG": {
                                newPrerequisites.add(new ItemRequirementBuilder(new AnyLogScope(), number));
                                continue block38;
                            }
                            case "ANY_PLANK": {
                                newPrerequisites.add(new ItemRequirementBuilder(new AnyPlankScope(), number));
                                continue block38;
                            }
                            case "ANY_STONE": {
                                newPrerequisites.add(new ItemRequirementBuilder(new AnyStoneScope(), number));
                                continue block38;
                            }
                        }
                        newPrerequisites.add(new ItemRequirementBuilder(new MaterialScope(Material.valueOf((String)ressourcesKey)), number));
                    }
                }
                ConfigurationSection benefitsSection = upgradesSection.getConfigurationSection(key + ".benefits");
                ArrayList<IndividualStat> rewards = new ArrayList<IndividualStat>();
                if (benefitsSection != null) {
                    for (String benefitKey : benefitsSection.getKeys(false)) {
                        boolean isUnlimited = NewUpgradeStorage.isInfiniteValue(benefitsSection, benefitKey);
                        int intValue = NewUpgradeStorage.parseIntValue(benefitsSection, benefitKey);
                        switch (benefitKey) {
                            case "PROPERTY_CAP": {
                                rewards.add(new PropertyCap(intValue, isUnlimited));
                                break;
                            }
                            case "PLAYER_CAP": {
                                rewards.add(new TownPlayerCap(intValue, isUnlimited));
                                break;
                            }
                            case "CHUNK_CAP": {
                                rewards.add(new ChunkCap(intValue, isUnlimited));
                                break;
                            }
                            case "CHUNK_COST": {
                                rewards.add(new ChunkCost(intValue, isUnlimited));
                                break;
                            }
                            case "LANDMARKS_CAP": {
                                rewards.add(new LandmarkCap(intValue, isUnlimited));
                                break;
                            }
                            case "UNLOCK_TOWN_SPAWN": {
                                rewards.add(new EnableTownSpawn(true));
                                break;
                            }
                            case "UNLOCK_MOB_BAN": {
                                rewards.add(new EnableMobBan(true));
                                break;
                            }
                            case "LANDMARK_BONUS": {
                                rewards.add(new LandmarkBonus(benefitsSection.getDouble(benefitKey) / 100.0));
                                break;
                            }
                            case "UNLOCK_NEW_PERMISSIONS": {
                                List permissions = benefitsSection.getStringList(benefitKey);
                                rewards.add(new PermissionList(permissions));
                                break;
                            }
                            case "AUTHORIZED_BIOMES": {
                                List biomeKeys = benefitsSection.getStringList(benefitKey);
                                rewards.add(BiomeStat.fromStrings(biomeKeys));
                            }
                        }
                    }
                }
                upgradeMap.put(key, new Upgrade(row, col, key, icon, maxLevel, newPrerequisites, rewards));
            }
        }
    }

    private static boolean isInfiniteValue(ConfigurationSection section, String path) {
        String raw = section.getString(path);
        if (raw == null) {
            return false;
        }
        return (raw = raw.trim().toLowerCase()).equals("infinity") || raw.equals("inf") || raw.equals("\u221e") || raw.equals("unlimited");
    }

    private static int parseIntValue(ConfigurationSection section, String path) {
        String raw = section.getString(path);
        if (raw == null) {
            return 0;
        }
        if ((raw = raw.trim().toLowerCase()).equals("infinity") || raw.equals("inf") || raw.equals("\u221e") || raw.equals("unlimited")) {
            return 0;
        }
        try {
            return Integer.parseInt(raw.replace("+", ""));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public Upgrade getUpgradeByName(TerritoryData territoryData, String name) {
        if (territoryData instanceof RegionData) {
            return this.regionUpgrades.get(name);
        }
        return this.townUpgrades.get(name);
    }

    public Collection<Upgrade> getUpgrades(StatsType statsType) {
        StatsType statsType2 = statsType;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"REGION", "TOWN"}, (StatsType)statsType2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> this.regionUpgrades.values();
            case 1 -> this.townUpgrades.values();
            case -1 -> this.townUpgrades.values();
        };
    }

    public Collection<Upgrade> getUpgrades(TerritoryData territoryData) {
        if (territoryData instanceof RegionData) {
            return this.getUpgrades(StatsType.REGION);
        }
        return this.getUpgrades(StatsType.TOWN);
    }
}

