/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.upgrade.rewards.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.upgrade.rewards.AggregatableStat;
import org.leralix.tan.upgrade.rewards.IndividualStat;

public class PermissionList
extends IndividualStat
implements AggregatableStat<PermissionList> {
    private final List<String> values;

    public PermissionList() {
        this.values = Collections.emptyList();
    }

    public PermissionList(Collection<String> values) {
        this.values = List.copyOf(values);
    }

    public Collection<String> getValues() {
        return this.values;
    }

    @Override
    public PermissionList aggregate(List<PermissionList> stats) {
        ArrayList<String> res = new ArrayList<String>();
        for (PermissionList stat : stats) {
            res.addAll(stat.values);
        }
        return new PermissionList(res);
    }

    @Override
    public PermissionList scale(int factor) {
        if (factor > 0) {
            return this;
        }
        return new PermissionList();
    }

    @Override
    public FilledLang getStatReward(LangType langType, int level, int maxLevel) {
        String nbNewCommands = this.getMathSign(this.values.size());
        if (level == 0) {
            return Lang.UPGRADE_LINE_INT.get(Lang.UNLOCK_PERMISSION.get(langType, new String[0]), "0", nbNewCommands);
        }
        return Lang.UPGRADE_LINE_INT_MAX.get(Lang.UNLOCK_PERMISSION.get(langType, new String[0]), nbNewCommands);
    }

    @Override
    public FilledLang getStatReward(LangType langType) {
        if (this.values.isEmpty()) {
            return Lang.UPGRADE_LINE_INT_MAX.get(Lang.UNLOCK_PERMISSION.get(langType, new String[0]), "0");
        }
        String nbNewCommands = this.getMathSign(this.values.size());
        return Lang.UPGRADE_LINE_INT_MAX.get(Lang.UNLOCK_PERMISSION.get(langType, new String[0]), nbNewCommands);
    }
}

