/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.upgrade.rewards.numeric;

import java.util.List;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.upgrade.rewards.AggregatableStat;
import org.leralix.tan.upgrade.rewards.numeric.NumericStat;

public class ChunkCap
extends NumericStat
implements AggregatableStat<ChunkCap> {
    public ChunkCap() {
        super(0, false);
    }

    public ChunkCap(int maxAmount, boolean isUnlimited) {
        super(maxAmount, isUnlimited);
    }

    public String getMaxNumberOfChunks() {
        if (this.isUnlimited) {
            return "\u221e";
        }
        return Integer.toString(this.maxAmount);
    }

    @Override
    public ChunkCap aggregate(List<ChunkCap> stats) {
        int totalCap = 0;
        boolean unlimitedFound = false;
        for (ChunkCap stat : stats) {
            if (stat.isUnlimited) {
                unlimitedFound = true;
            }
            totalCap += stat.maxAmount;
        }
        return new ChunkCap(totalCap, unlimitedFound);
    }

    @Override
    public ChunkCap scale(int factor) {
        return new ChunkCap(this.maxAmount * factor, this.isUnlimited);
    }

    @Override
    public FilledLang getStatReward(LangType langType, int level, int maxLevel) {
        return this.getStatReward(langType, level, maxLevel, Lang.CHUNK_CAP);
    }

    @Override
    public FilledLang getStatReward(LangType langType) {
        return this.getStatReward(langType, Lang.CHUNK_CAP);
    }
}

