/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.shadow.mysql.cj.jdbc;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.leralix.shadow.mysql.cj.conf.PropertyKey;
import org.leralix.shadow.mysql.cj.jdbc.MysqlConnectionPoolDataSource;
import org.leralix.shadow.mysql.cj.jdbc.MysqlDataSource;
import org.leralix.shadow.mysql.cj.jdbc.MysqlXADataSource;
import org.leralix.shadow.mysql.cj.util.Util;

public class MysqlDataSourceFactory
implements ObjectFactory {
    protected static final String DATA_SOURCE_CLASS_NAME = MysqlDataSource.class.getName();
    protected static final String POOL_DATA_SOURCE_CLASS_NAME = MysqlConnectionPoolDataSource.class.getName();
    protected static final String XA_DATA_SOURCE_CLASS_NAME = MysqlXADataSource.class.getName();

    @Override
    public Object getObjectInstance(Object refObj, Name nm, Context ctx, Hashtable<?, ?> env) throws Exception {
        Reference ref = (Reference)refObj;
        String className = ref.getClassName();
        if (className != null && (className.equals(DATA_SOURCE_CLASS_NAME) || className.equals(POOL_DATA_SOURCE_CLASS_NAME) || className.equals(XA_DATA_SOURCE_CLASS_NAME))) {
            String explicitUrlAsString;
            String databaseName;
            String serverName;
            String password;
            MysqlDataSource dataSource = Util.getInstance(MysqlDataSource.class, className, null, null, null);
            int portNumber = 3306;
            String portNumberAsString = this.nullSafeRefAddrStringGet("port", ref);
            if (portNumberAsString != null) {
                portNumber = Integer.parseInt(portNumberAsString);
            }
            dataSource.setPort(portNumber);
            String user = this.nullSafeRefAddrStringGet(PropertyKey.USER.getKeyName(), ref);
            if (user != null) {
                dataSource.setUser(user);
            }
            if ((password = this.nullSafeRefAddrStringGet(PropertyKey.PASSWORD.getKeyName(), ref)) != null) {
                dataSource.setPassword(password);
            }
            if ((serverName = this.nullSafeRefAddrStringGet("serverName", ref)) != null) {
                dataSource.setServerName(serverName);
            }
            if ((databaseName = this.nullSafeRefAddrStringGet("databaseName", ref)) != null) {
                dataSource.setDatabaseName(databaseName);
            }
            if ((explicitUrlAsString = this.nullSafeRefAddrStringGet("explicitUrl", ref)) != null && Boolean.parseBoolean(explicitUrlAsString)) {
                dataSource.setUrl(this.nullSafeRefAddrStringGet("url", ref));
            }
            dataSource.setPropertiesViaRef(ref);
            return dataSource;
        }
        return null;
    }

    private String nullSafeRefAddrStringGet(String referenceName, Reference ref) {
        RefAddr refAddr = ref.get(referenceName);
        String asString = refAddr != null ? (String)refAddr.getContent() : null;
        return asString;
    }
}

