/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.shadow.mysql.cj.protocol.a;

import org.leralix.shadow.mysql.cj.exceptions.ExceptionFactory;
import org.leralix.shadow.mysql.cj.exceptions.WrongArgumentException;
import org.leralix.shadow.mysql.cj.protocol.ColumnDefinition;
import org.leralix.shadow.mysql.cj.protocol.ProtocolEntityFactory;
import org.leralix.shadow.mysql.cj.protocol.a.ColumnDefinitionFactory;
import org.leralix.shadow.mysql.cj.protocol.a.NativePacketPayload;
import org.leralix.shadow.mysql.cj.result.DefaultColumnDefinition;
import org.leralix.shadow.mysql.cj.result.Field;

public class MergingColumnDefinitionFactory
extends ColumnDefinitionFactory
implements ProtocolEntityFactory<ColumnDefinition, NativePacketPayload> {
    public MergingColumnDefinitionFactory(long columnCount, ColumnDefinition columnDefinitionFromCache) {
        super(columnCount, columnDefinitionFromCache);
    }

    @Override
    public boolean mergeColumnDefinitions() {
        return true;
    }

    @Override
    public ColumnDefinition createFromFields(Field[] fields) {
        if (this.columnDefinitionFromCache != null) {
            if ((long)fields.length != this.columnCount) {
                throw ExceptionFactory.createException(WrongArgumentException.class, "Wrong number of ColumnDefinition fields.");
            }
            Field[] f = this.columnDefinitionFromCache.getFields();
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setFlags(f[i].getFlags());
            }
        }
        return new DefaultColumnDefinition(fields);
    }
}

