/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.shadow.mysql.cj.result;

import java.time.LocalDateTime;
import org.leralix.shadow.mysql.cj.Messages;
import org.leralix.shadow.mysql.cj.conf.PropertySet;
import org.leralix.shadow.mysql.cj.exceptions.DataReadException;
import org.leralix.shadow.mysql.cj.protocol.InternalDate;
import org.leralix.shadow.mysql.cj.protocol.InternalTime;
import org.leralix.shadow.mysql.cj.protocol.InternalTimestamp;
import org.leralix.shadow.mysql.cj.result.AbstractDateTimeValueFactory;

public class LocalDateTimeValueFactory
extends AbstractDateTimeValueFactory<LocalDateTime> {
    public LocalDateTimeValueFactory(PropertySet pset) {
        super(pset);
    }

    @Override
    public LocalDateTime localCreateFromDate(InternalDate idate) {
        return (LocalDateTime)this.createFromTimestamp(new InternalTimestamp(idate.getYear(), idate.getMonth(), idate.getDay(), 0, 0, 0, 0, 0));
    }

    @Override
    public LocalDateTime localCreateFromTime(InternalTime it) {
        if (it.getHours() < 0 || it.getHours() >= 24) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidTimeValue", new Object[]{it.toString()}));
        }
        return (LocalDateTime)this.createFromTimestamp(new InternalTimestamp(1970, 1, 1, it.getHours(), it.getMinutes(), it.getSeconds(), it.getNanos(), it.getScale()));
    }

    @Override
    public LocalDateTime localCreateFromTimestamp(InternalTimestamp its) {
        if (its.getYear() == 0 && its.getMonth() == 0 && its.getDay() == 0) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidZeroDate"));
        }
        return LocalDateTime.of(its.getYear(), its.getMonth(), its.getDay(), its.getHours(), its.getMinutes(), its.getSeconds(), its.getNanos());
    }

    @Override
    public LocalDateTime localCreateFromDatetime(InternalTimestamp its) {
        if (its.getYear() == 0 && its.getMonth() == 0 && its.getDay() == 0) {
            throw new DataReadException(Messages.getString("ResultSet.InvalidZeroDate"));
        }
        return LocalDateTime.of(its.getYear(), its.getMonth(), its.getDay(), its.getHours(), its.getMinutes(), its.getSeconds(), its.getNanos());
    }

    @Override
    public String getTargetTypeName() {
        return LocalDateTime.class.getName();
    }
}

