/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.shadow.mysql.cj.xdevapi;

import java.util.ArrayList;
import java.util.List;
import org.leralix.shadow.mysql.cj.MysqlxSession;
import org.leralix.shadow.mysql.cj.conf.PropertySet;
import org.leralix.shadow.mysql.cj.exceptions.ExceptionFactory;
import org.leralix.shadow.mysql.cj.exceptions.WrongArgumentException;
import org.leralix.shadow.mysql.cj.protocol.ColumnDefinition;
import org.leralix.shadow.mysql.cj.protocol.ProtocolEntity;
import org.leralix.shadow.mysql.cj.protocol.ResultBuilder;
import org.leralix.shadow.mysql.cj.protocol.x.FetchDoneEntity;
import org.leralix.shadow.mysql.cj.protocol.x.Notice;
import org.leralix.shadow.mysql.cj.protocol.x.StatementExecuteOk;
import org.leralix.shadow.mysql.cj.protocol.x.StatementExecuteOkBuilder;
import org.leralix.shadow.mysql.cj.result.BufferedRowList;
import org.leralix.shadow.mysql.cj.result.DefaultColumnDefinition;
import org.leralix.shadow.mysql.cj.result.Field;
import org.leralix.shadow.mysql.cj.result.Row;
import org.leralix.shadow.mysql.cj.result.RowList;
import org.leralix.shadow.mysql.cj.xdevapi.DocResult;
import org.leralix.shadow.mysql.cj.xdevapi.DocResultImpl;

public class DocResultBuilder
implements ResultBuilder<DocResult> {
    private ArrayList<Field> fields = new ArrayList();
    private ColumnDefinition metadata;
    private List<Row> rows = new ArrayList<Row>();
    private DocResult result;
    PropertySet pset;
    private StatementExecuteOkBuilder statementExecuteOkBuilder = new StatementExecuteOkBuilder();

    public DocResultBuilder(MysqlxSession sess) {
        this.pset = sess.getPropertySet();
    }

    @Override
    public boolean addProtocolEntity(ProtocolEntity entity) {
        if (entity instanceof Field) {
            this.fields.add((Field)entity);
            return false;
        }
        if (entity instanceof Row) {
            if (this.metadata == null) {
                this.metadata = new DefaultColumnDefinition(this.fields.toArray(new Field[0]));
            }
            this.rows.add(((Row)entity).setMetadata(this.metadata));
            return false;
        }
        if (entity instanceof Notice) {
            this.statementExecuteOkBuilder.addProtocolEntity(entity);
            return false;
        }
        if (entity instanceof FetchDoneEntity) {
            return false;
        }
        if (entity instanceof StatementExecuteOk) {
            return true;
        }
        throw ExceptionFactory.createException(WrongArgumentException.class, "Unexpected protocol entity " + entity);
    }

    @Override
    public DocResult build() {
        this.result = new DocResultImpl((RowList)new BufferedRowList(this.rows), () -> this.statementExecuteOkBuilder.build(), this.pset);
        return this.result;
    }
}

