/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.leralix.lib.SphereLib;
import org.leralix.lib.data.PluginVersion;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.api.external.papi.PlaceHolderAPI;
import org.leralix.tan.api.external.worldguard.WorldGuardManager;
import org.leralix.tan.api.internal.InternalAPI;
import org.leralix.tan.bstat.bukkit.Metrics;
import org.leralix.tan.commands.admin.AdminCommandManager;
import org.leralix.tan.commands.debug.DebugCommandManager;
import org.leralix.tan.commands.player.PlayerCommandManager;
import org.leralix.tan.commands.server.ServerCommandManager;
import org.leralix.tan.economy.EconomyUtil;
import org.leralix.tan.economy.TanEconomyStandalone;
import org.leralix.tan.economy.VaultManager;
import org.leralix.tan.events.EventManager;
import org.leralix.tan.events.newsletter.NewsletterEvents;
import org.leralix.tan.events.newsletter.NewsletterStorage;
import org.leralix.tan.events.newsletter.NewsletterType;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.lang.DynamicLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.ChatScopeListener;
import org.leralix.tan.listeners.ChunkListener;
import org.leralix.tan.listeners.CommandBlocker;
import org.leralix.tan.listeners.EconomyInitialiser;
import org.leralix.tan.listeners.LandmarkChestListener;
import org.leralix.tan.listeners.MobSpawnListener;
import org.leralix.tan.listeners.PlayerEnterChunkListener;
import org.leralix.tan.listeners.PlayerJoinListener;
import org.leralix.tan.listeners.PropertySignListener;
import org.leralix.tan.listeners.SpawnListener;
import org.leralix.tan.listeners.chat.ChatListener;
import org.leralix.tan.listeners.interact.RightClickListener;
import org.leralix.tan.storage.ClaimBlacklistStorage;
import org.leralix.tan.storage.MobChunkSpawnStorage;
import org.leralix.tan.storage.database.DatabaseHandler;
import org.leralix.tan.storage.database.MySqlHandler;
import org.leralix.tan.storage.database.SQLiteHandler;
import org.leralix.tan.storage.impl.FortDataStorage;
import org.leralix.tan.storage.legacy.UpgradeStorage;
import org.leralix.tan.storage.stored.FortStorage;
import org.leralix.tan.storage.stored.LandmarkStorage;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.storage.stored.PlannedAttackStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.storage.stored.RegionDataStorage;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.storage.stored.TruceStorage;
import org.leralix.tan.storage.stored.WarStorage;
import org.leralix.tan.tasks.DailyTasks;
import org.leralix.tan.tasks.SaveStats;
import org.leralix.tan.tasks.SecondTask;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.constants.DatabaseConstants;
import org.leralix.tan.utils.gameplay.TANCustomNBT;
import org.leralix.tan.utils.text.NumberUtil;
import org.tan.api.TanAPI;

public class TownsAndNations
extends JavaPlugin {
    private static TownsAndNations plugin;
    private static final String USER_AGENT = "Mozilla/5.0";
    private static final String GITHUB_API_URL = "https://api.github.com/repos/leralix/towns-and-nations/releases/latest";
    private static final PluginVersion CURRENT_VERSION;
    private static final PluginVersion MINIMUM_SUPPORTING_DYNMAP;
    private static final PluginVersion MINIMUM_SUPPORTING_SPHERELIB;
    private PluginVersion latestVersion;
    private boolean loadedSuccessfully = false;
    private DatabaseHandler databaseHandler;

    public void onEnable() {
        plugin = this;
        this.getLogger().log(Level.INFO, "\u001b[33m----------------Towns & Nations------------------\u001b[0m");
        this.getLogger().log(Level.INFO, "To report a bug or request a feature, please ask on my discord server: https://discord.gg/Q8gZSFUuzb");
        this.getLogger().log(Level.INFO, "[TaN] Loading Plugin");
        if (SphereLib.getPluginVersion().isOlderThan(MINIMUM_SUPPORTING_SPHERELIB)) {
            this.getLogger().log(Level.SEVERE, "[TaN] You need to update SphereLib to use this version of Towns and Nations");
            this.getLogger().log(Level.SEVERE, "[TaN] Please update SphereLib to version " + String.valueOf(MINIMUM_SUPPORTING_SPHERELIB) + " or higher");
            this.getLogger().log(Level.SEVERE, "[TaN] Disabling plugin");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().log(Level.INFO, "[TaN] -Loading Lang");
        ConfigUtil.saveAndUpdateResource((Plugin)this, (String)"lang.yml");
        ConfigUtil.addCustomConfig((Plugin)this, (String)"lang.yml", (ConfigTag)ConfigTag.LANG);
        String lang = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.LANG).getString("language");
        File langFolder = new File(TownsAndNations.getPlugin().getDataFolder(), "lang");
        Lang.loadTranslations(langFolder, lang);
        DynamicLang.loadTranslations(langFolder, lang);
        this.getLogger().info(Lang.LANGUAGE_SUCCESSFULLY_LOADED.getDefault());
        this.getLogger().log(Level.INFO, "[TaN] -Loading Configs");
        ArrayList<String> mainBlackList = new ArrayList<String>();
        mainBlackList.add("claimBlacklist");
        mainBlackList.add("wildernessRules");
        mainBlackList.add("allowedTimeSlotsWar");
        ConfigUtil.saveAndUpdateResource((Plugin)this, (String)"config.yml", mainBlackList);
        ConfigUtil.addCustomConfig((Plugin)this, (String)"config.yml", (ConfigTag)ConfigTag.MAIN);
        ArrayList<String> upgradeBlackList = new ArrayList<String>();
        upgradeBlackList.add("upgrades");
        ConfigUtil.saveAndUpdateResource((Plugin)this, (String)"upgrades.yml", upgradeBlackList);
        ConfigUtil.addCustomConfig((Plugin)this, (String)"upgrades.yml", (ConfigTag)ConfigTag.UPGRADE);
        this.getLogger().log(Level.INFO, "[TaN] -Loading Configs");
        Constants.init(ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN));
        UpgradeStorage.init();
        MobChunkSpawnStorage.init();
        ClaimBlacklistStorage.init();
        NewsletterType.init();
        IconManager.getInstance();
        NumberUtil.init();
        FortStorage.init(new FortDataStorage());
        this.getLogger().log(Level.INFO, "[TaN] -Loading Economy");
        this.setupEconomy();
        this.getLogger().log(Level.INFO, "[TaN] -Loading Database");
        this.loadDB();
        this.getLogger().log(Level.INFO, "[TaN] -Loading Local data");
        RegionDataStorage.getInstance();
        PlayerDataStorage.getInstance();
        NewClaimedChunkStorage.getInstance();
        TownDataStorage.getInstance();
        LandmarkStorage.getInstance();
        PlannedAttackStorage.getInstance();
        NewsletterStorage.getInstance();
        WarStorage.getInstance();
        EventManager.getInstance().registerEvents(new NewsletterEvents());
        TruceStorage.getInstance();
        this.getLogger().log(Level.INFO, "[TaN] -Loading blocks data");
        TANCustomNBT.setBlocsData();
        this.getLogger().log(Level.INFO, "[TaN] -Loading commands");
        SaveStats.startSchedule();
        DailyTasks dailyTasks = new DailyTasks(Constants.getDailyTaskHour(), Constants.getDailyTaskMinute());
        dailyTasks.scheduleMidnightTask();
        this.enableEventList();
        this.getCommand("tan").setExecutor((CommandExecutor)new PlayerCommandManager());
        this.getCommand("tanadmin").setExecutor((CommandExecutor)new AdminCommandManager());
        this.getCommand("tandebug").setExecutor((CommandExecutor)new DebugCommandManager());
        this.getCommand("tanserver").setExecutor((CommandExecutor)new ServerCommandManager());
        this.getLogger().log(Level.INFO, "[TaN] -Registering Dependencies");
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            this.getLogger().log(Level.INFO, "[TaN] -Registering PlaceholderAPI");
            new PlaceHolderAPI().register();
        }
        if (Bukkit.getPluginManager().isPluginEnabled("WorldGuard")) {
            this.getLogger().log(Level.INFO, "[TaN] -Registering WorldGuard");
            WorldGuardManager.getInstance().register();
        }
        this.checkForUpdate();
        this.getLogger().log(Level.INFO, "[TaN] -Registering API");
        TanAPI.register(new InternalAPI(CURRENT_VERSION, MINIMUM_SUPPORTING_DYNMAP));
        this.initBStats();
        this.getLogger().log(Level.INFO, "[TaN] -Registering Tasks");
        SecondTask secondTask = new SecondTask();
        secondTask.startScheduler();
        this.loadedSuccessfully = true;
        this.getLogger().log(Level.INFO, "[TaN] Plugin loaded successfully");
        this.getLogger().info("\u001b[33m----------------Towns & Nations------------------\u001b[0m");
    }

    private void initBStats() {
        try {
            new Metrics((Plugin)this, 20527);
        }
        catch (IllegalStateException e) {
            this.getLogger().log(Level.WARNING, "[TaN] Failed to submit stats to bStats");
        }
    }

    private void loadDB() {
        DatabaseConstants constants = Constants.databaseConstants();
        String dbName = constants.getDbType();
        if (dbName.equalsIgnoreCase("sqlite")) {
            String dbPath = this.getDataFolder().getAbsolutePath() + "/database/main.db";
            this.databaseHandler = new SQLiteHandler(dbPath);
        }
        if (dbName.equals("mysql")) {
            this.databaseHandler = new MySqlHandler(constants.getHost(), constants.getPort(), constants.getDbType(), constants.getUser(), constants.getPassword());
        }
        try {
            this.databaseHandler.connect();
        }
        catch (SQLException e) {
            this.getLogger().log(Level.SEVERE, "[TaN] Error while connecting to the database");
        }
    }

    private void setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.getLogger().log(Level.INFO, "[TaN] -Vault is not detected. Running standalone economy");
            EconomyUtil.register(new TanEconomyStandalone());
            return;
        }
        VaultManager.setupVault();
    }

    public void onDisable() {
        if (!this.loadedSuccessfully) {
            this.getLogger().info("[TaN] Not saving data because plugin crashed during loading");
            this.getLogger().info("[TaN] Plugin disabled");
            return;
        }
        this.getLogger().info("[TaN] Savings Data");
        SaveStats.saveAll();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.getLogger().info("[TaN] Plugin disabled");
    }

    private void enableEventList() {
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new ChatListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new ChunkListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerJoinListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PlayerEnterChunkListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new ChatScopeListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new MobSpawnListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new SpawnListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new PropertySignListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new LandmarkChestListener(), (Plugin)this);
        pluginManager.registerEvents((Listener)new EconomyInitialiser(), (Plugin)this);
        pluginManager.registerEvents((Listener)new CommandBlocker(), (Plugin)this);
        pluginManager.registerEvents((Listener)new RightClickListener(), (Plugin)this);
    }

    public static TownsAndNations getPlugin() {
        return plugin;
    }

    private void checkForUpdate() {
        if (!TownsAndNations.getPlugin().getConfig().getBoolean("CheckForUpdate", true)) {
            this.getLogger().info("[TaN] Update check is disabled");
            this.latestVersion = CURRENT_VERSION;
            return;
        }
        try {
            URL url = new URL(GITHUB_API_URL);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestMethod("GET");
            con.setRequestProperty("User-Agent", USER_AGENT);
            int responseCode = con.getResponseCode();
            if (responseCode == 200) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                this.latestVersion = this.extractVersionFromResponse(response.toString());
                if (CURRENT_VERSION.isOlderThan(this.latestVersion)) {
                    this.getLogger().log(Level.INFO, "[TaN] A new version is available : {0}", this.latestVersion);
                } else {
                    this.getLogger().info("[TaN] Towns and Nation is up to date: " + String.valueOf(CURRENT_VERSION));
                }
            } else {
                this.getLogger().info("[TaN] An error occurred while trying to accesses github API.");
                this.getLogger().info("[TaN] Error log : " + String.valueOf(con.getInputStream()));
            }
        }
        catch (Exception e) {
            this.getLogger().warning("[TaN] An error occurred while trying to check for updates.");
            this.latestVersion = CURRENT_VERSION;
        }
    }

    private PluginVersion extractVersionFromResponse(String response) {
        JsonObject jsonResponse = JsonParser.parseString((String)response).getAsJsonObject();
        String version = jsonResponse.get("tag_name").getAsString();
        return new PluginVersion(version);
    }

    public boolean isLatestVersion() {
        return !CURRENT_VERSION.isOlderThan(this.latestVersion);
    }

    public PluginVersion getLatestVersion() {
        return this.latestVersion;
    }

    public PluginVersion getCurrentVersion() {
        return CURRENT_VERSION;
    }

    public PluginVersion getMinimumSupportingDynmap() {
        return MINIMUM_SUPPORTING_DYNMAP;
    }

    public DatabaseHandler getDatabaseHandler() {
        return this.databaseHandler;
    }

    public void resetSingletonForTests() {
        RegionDataStorage.getInstance().reset();
        PlayerDataStorage.getInstance().reset();
        TownDataStorage.getInstance().reset();
        LandmarkStorage.getInstance().reset();
        PlannedAttackStorage.getInstance().reset();
        WarStorage.getInstance().reset();
        NewClaimedChunkStorage.getInstance().reset();
    }

    static {
        CURRENT_VERSION = new PluginVersion(Integer.valueOf(0), Integer.valueOf(16), Integer.valueOf(2));
        MINIMUM_SUPPORTING_DYNMAP = new PluginVersion(Integer.valueOf(0), Integer.valueOf(14), Integer.valueOf(0));
        MINIMUM_SUPPORTING_SPHERELIB = new PluginVersion(Integer.valueOf(0), Integer.valueOf(6), Integer.valueOf(0));
    }
}

