/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.api.external.papi.entries;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.api.external.papi.entries.PapiEntry;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.LocalChatStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;

public class OtherPlayerChatMode
extends PapiEntry {
    public OtherPlayerChatMode() {
        super("chat_mode_{}");
    }

    @Override
    public String getData(OfflinePlayer player, @NotNull String params) {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player.getUniqueId());
        if (tanPlayer == null) {
            return "[TAN] Player data not found";
        }
        LangType langType = tanPlayer.getLang();
        String[] values = OtherPlayerChatMode.extractValues(params);
        OfflinePlayer playerSelected = Bukkit.getOfflinePlayer((String)values[0]);
        if (!playerSelected.isOnline()) {
            return Lang.INVALID_PLAYER_NAME.get(langType, new String[0]);
        }
        return LocalChatStorage.getPlayerChatScope(playerSelected.getUniqueId().toString()).getName(langType);
    }
}

