/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.commands.server;

import java.util.Collections;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.leralix.lib.commands.SubCommand;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.text.TanChatUtils;

class DisbandTownServer
extends SubCommand {
    DisbandTownServer() {
    }

    public String getName() {
        return "disbandtown";
    }

    public String getDescription() {
        return Lang.DISBAND_TOWN_SERVER_DESC.getDefault();
    }

    public int getArguments() {
        return 2;
    }

    public String getSyntax() {
        return "/tanserver disbandtown <player_username>";
    }

    public List<String> getTabCompleteSuggestions(CommandSender player, String currentMessage, String[] args) {
        return Collections.emptyList();
    }

    public void perform(CommandSender commandSender, String[] args) {
        if (args.length < 2) {
            TanChatUtils.message(commandSender, Lang.INVALID_ARGUMENTS);
            return;
        }
        Player p = commandSender.getServer().getPlayer(args[1]);
        if (p == null) {
            TanChatUtils.message(commandSender, Lang.PLAYER_NOT_FOUND);
            return;
        }
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(p);
        TownData townData = tanPlayer.getTown();
        if (townData == null) {
            TanChatUtils.message(commandSender, Lang.PLAYER_NO_TOWN);
            return;
        }
        if (townData.isCapital()) {
            TanChatUtils.message(commandSender, Lang.CANNOT_DELETE_TERRITORY_IF_CAPITAL);
            return;
        }
        townData.delete();
    }
}

