/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.leralix.tan.dataclass.UpgradeStatus;
import org.leralix.tan.dataclass.territory.permission.ChunkPermission;
import org.leralix.tan.dataclass.territory.permission.RelationPermission;
import org.leralix.tan.enums.MobChunkSpawnEnum;
import org.leralix.tan.enums.permissions.ChunkPermissionType;
import org.leralix.tan.enums.permissions.GeneralChunkSetting;

public class ClaimedChunkSettings {
    private Map<ChunkPermissionType, ChunkPermission> newPermission = new EnumMap<ChunkPermissionType, ChunkPermission>(ChunkPermissionType.class);
    private Map<String, UpgradeStatus> mobSpawnStorage = new HashMap<String, UpgradeStatus>();
    private Map<GeneralChunkSetting, Boolean> generalSettings = new EnumMap<GeneralChunkSetting, Boolean>(GeneralChunkSetting.class);

    public ClaimedChunkSettings() {
        for (ChunkPermissionType chunkPermissionType : ChunkPermissionType.values()) {
            this.newPermission.put(chunkPermissionType, new ChunkPermission(RelationPermission.TOWN));
        }
        for (Enum enum_ : GeneralChunkSetting.values()) {
            this.generalSettings.put((GeneralChunkSetting)enum_, false);
        }
    }

    public Map<ChunkPermissionType, ChunkPermission> getChunkPermissions() {
        if (this.newPermission == null) {
            this.newPermission = new EnumMap<ChunkPermissionType, ChunkPermission>(ChunkPermissionType.class);
        }
        return this.newPermission;
    }

    public Map<GeneralChunkSetting, Boolean> getChunkSetting() {
        return this.generalSettings;
    }

    public ChunkPermission getPermission(ChunkPermissionType type) {
        Map<ChunkPermissionType, ChunkPermission> map = this.getChunkPermissions();
        map.putIfAbsent(type, new ChunkPermission(RelationPermission.TOWN));
        return map.get((Object)type);
    }

    public void nextPermission(ChunkPermissionType type) {
        this.getChunkPermissions().get((Object)type).nextPermission();
    }

    public UpgradeStatus getSpawnControl(MobChunkSpawnEnum mobType) {
        return this.getSpawnControl(mobType.name());
    }

    public UpgradeStatus getSpawnControl(String mobType) {
        this.mobSpawnStorage.putIfAbsent(mobType, new UpgradeStatus(false, false));
        return this.mobSpawnStorage.get(mobType);
    }
}

