/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.dataclass.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.position.Vector3D;
import org.leralix.lib.utils.RandomUtil;
import org.leralix.tan.building.Building;
import org.leralix.tan.dataclass.ClaimedChunkSettings;
import org.leralix.tan.dataclass.DiplomacyProposal;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.RankData;
import org.leralix.tan.dataclass.RelationData;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.chunk.TerritoryChunk;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.dataclass.territory.cosmetic.CustomIcon;
import org.leralix.tan.dataclass.territory.cosmetic.ICustomIcon;
import org.leralix.tan.dataclass.territory.cosmetic.PlayerHeadIcon;
import org.leralix.tan.dataclass.territory.economy.Budget;
import org.leralix.tan.dataclass.territory.economy.ChunkUpkeepLine;
import org.leralix.tan.dataclass.territory.economy.SalaryPaymentLine;
import org.leralix.tan.dataclass.territory.permission.ChunkPermission;
import org.leralix.tan.economy.EconomyUtil;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.enums.permissions.ChunkPermissionType;
import org.leralix.tan.events.EventManager;
import org.leralix.tan.events.events.DiplomacyProposalAcceptedInternalEvent;
import org.leralix.tan.events.events.DiplomacyProposalInternalEvent;
import org.leralix.tan.events.events.TerritoryVassalAcceptedInternalEvent;
import org.leralix.tan.events.events.TerritoryVassalProposalInternalEvent;
import org.leralix.tan.gui.cosmetic.type.IconBuilder;
import org.leralix.tan.gui.legacy.PlayerGUI;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.ClaimBlacklistStorage;
import org.leralix.tan.storage.CurrentAttacksStorage;
import org.leralix.tan.storage.database.transactions.TransactionManager;
import org.leralix.tan.storage.database.transactions.instance.DonationTransaction;
import org.leralix.tan.storage.database.transactions.instance.SalaryTransaction;
import org.leralix.tan.storage.stored.FortStorage;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.storage.stored.PlannedAttackStorage;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.upgrade.TerritoryStats;
import org.leralix.tan.upgrade.rewards.StatsType;
import org.leralix.tan.upgrade.rewards.list.BiomeStat;
import org.leralix.tan.upgrade.rewards.numeric.ChunkCap;
import org.leralix.tan.upgrade.rewards.numeric.ChunkCost;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.file.FileUtil;
import org.leralix.tan.utils.gameplay.TerritoryUtil;
import org.leralix.tan.utils.graphic.PrefixUtil;
import org.leralix.tan.utils.graphic.TeamUtils;
import org.leralix.tan.utils.territory.ChunkUtil;
import org.leralix.tan.utils.text.StringUtil;
import org.leralix.tan.utils.text.TanChatUtils;
import org.leralix.tan.war.PlannedAttack;
import org.leralix.tan.war.fort.Fort;
import org.leralix.tan.war.legacy.CurrentAttack;

public abstract class TerritoryData {
    protected String id;
    protected String name;
    protected String description;
    protected String overlordID;
    private Double treasury;
    private final Long dateTimeCreated;
    private ICustomIcon customIcon;
    private RelationData relations;
    private Double baseTax;
    private double propertyRentTax;
    private double propertyBuyTax;
    private double propertyCreateTax;
    protected Integer color;
    protected Integer defaultRankID;
    protected Map<Integer, RankData> ranks;
    private Collection<String> attackIncomingList;
    private HashMap<String, Integer> availableClaims;
    private Map<String, DiplomacyProposal> diplomacyProposals;
    private List<String> overlordsProposals;
    private ClaimedChunkSettings chunkSettings;
    private List<String> fortIds;
    private List<String> occupiedFortIds;
    protected TerritoryStats upgradesStatus;

    protected TerritoryData(String id, String name, ITanPlayer owner) {
        this.id = id;
        this.name = name;
        this.description = Lang.DEFAULT_DESCRIPTION.getDefault();
        this.dateTimeCreated = new Date().getTime();
        this.customIcon = new PlayerHeadIcon(owner);
        this.treasury = 0.0;
        this.baseTax = 1.0;
        this.propertyRentTax = 0.1;
        this.propertyBuyTax = 0.1;
        this.propertyCreateTax = 0.5;
        this.ranks = new HashMap<Integer, RankData>();
        RankData defaultRank = this.registerNewRank("default");
        this.setDefaultRank(defaultRank);
        this.attackIncomingList = new ArrayList<String>();
        this.availableClaims = new HashMap();
        this.diplomacyProposals = new HashMap<String, DiplomacyProposal>();
        this.overlordsProposals = new ArrayList<String>();
        this.chunkSettings = new ClaimedChunkSettings();
        this.color = StringUtil.randomColor();
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void rename(Player player, int cost, String newName) {
        if (this.getBalance() < (double)cost) {
            TanChatUtils.message(player, Lang.TERRITORY_NOT_ENOUGH_MONEY.get(player, this.getColoredName(), Double.toString((double)cost - this.getBalance())));
            return;
        }
        this.removeFromBalance(cost);
        FileUtil.addLineToHistory(Lang.HISTORY_TOWN_NAME_CHANGED.get(player.getName(), this.name, newName));
        TanChatUtils.message(player, Lang.CHANGE_MESSAGE_SUCCESS.get(player, this.name, newName), SoundEnum.GOOD);
        this.rename(newName);
    }

    public void rename(String newName) {
        this.name = newName;
    }

    public abstract int getHierarchyRank();

    public abstract String getBaseColoredName();

    public TextComponent getCustomColoredName() {
        TextComponent coloredName = new TextComponent(this.getName());
        coloredName.setColor(this.getChunkColor());
        return coloredName;
    }

    public abstract String getLeaderID();

    public abstract ITanPlayer getLeaderData();

    public abstract void setLeaderID(String var1);

    public boolean isLeader(ITanPlayer tanPlayer) {
        return this.isLeader(tanPlayer.getID());
    }

    public abstract boolean isLeader(String var1);

    public boolean isLeader(Player player) {
        return this.isLeader(player.getUniqueId().toString());
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = Lang.DEFAULT_DESCRIPTION.getDefault();
        }
        return this.description;
    }

    public void setDescription(String newDescription) {
        this.description = newDescription;
    }

    public ItemStack getIcon() {
        if (this.customIcon == null) {
            this.customIcon = this.haveNoLeader() ? new CustomIcon(new ItemStack(Material.BARRIER)) : new PlayerHeadIcon(this.getLeaderID());
        }
        return this.customIcon.getIcon();
    }

    public void setIcon(ICustomIcon icon) {
        this.customIcon = icon;
    }

    public abstract Collection<String> getPlayerIDList();

    public boolean isPlayerIn(ITanPlayer tanPlayer) {
        return this.isPlayerIn(tanPlayer.getID());
    }

    public boolean isPlayerIn(Player player) {
        return this.isPlayerIn(player.getUniqueId().toString());
    }

    public boolean isPlayerIn(String playerID) {
        return this.getPlayerIDList().contains(playerID);
    }

    public Collection<String> getOrderedPlayerIDList() {
        ArrayList<String> sortedList = new ArrayList<String>();
        List<ITanPlayer> playersSorted = this.getITanPlayerList().stream().sorted(Comparator.comparingInt(tanPlayer -> -this.getRank(tanPlayer.getRankID(this)).getLevel())).toList();
        for (ITanPlayer tanPlayer2 : playersSorted) {
            sortedList.add(tanPlayer2.getID());
        }
        return sortedList;
    }

    public abstract Collection<ITanPlayer> getITanPlayerList();

    public ClaimedChunkSettings getChunkSettings() {
        if (this.chunkSettings == null) {
            this.chunkSettings = new ClaimedChunkSettings();
        }
        return this.chunkSettings;
    }

    public RelationData getRelations() {
        if (this.relations == null) {
            this.relations = new RelationData();
        }
        return this.relations;
    }

    public void setRelation(TerritoryData otherTerritory, TownRelation newRelation) {
        TownRelation oldRelation = this.getRelationWith(otherTerritory);
        EventManager.getInstance().callEvent(new DiplomacyProposalAcceptedInternalEvent(otherTerritory, this, oldRelation, newRelation));
        this.getRelations().setRelation(newRelation, otherTerritory);
        otherTerritory.getRelations().setRelation(newRelation, this);
        TeamUtils.updateAllScoreboardColor();
    }

    private Map<String, DiplomacyProposal> getDiplomacyProposals() {
        if (this.diplomacyProposals == null) {
            this.diplomacyProposals = new HashMap<String, DiplomacyProposal>();
        }
        return this.diplomacyProposals;
    }

    public void removeDiplomaticProposal(TerritoryData proposingTerritory) {
        this.removeDiplomaticProposal(proposingTerritory.getID());
    }

    public void removeDiplomaticProposal(String proposingTerritoryID) {
        this.getDiplomacyProposals().remove(proposingTerritoryID);
    }

    private void addDiplomaticProposal(TerritoryData proposingTerritory, TownRelation wantedRelation) {
        EventManager.getInstance().callEvent(new DiplomacyProposalInternalEvent(this, proposingTerritory, wantedRelation));
        this.getDiplomacyProposals().put(proposingTerritory.getID(), new DiplomacyProposal(proposingTerritory.getID(), this.getID(), wantedRelation));
    }

    public void receiveDiplomaticProposal(TerritoryData proposingTerritory, TownRelation wantedRelation) {
        this.removeDiplomaticProposal(proposingTerritory);
        this.addDiplomaticProposal(proposingTerritory, wantedRelation);
    }

    public Collection<DiplomacyProposal> getAllDiplomacyProposal() {
        return this.getDiplomacyProposals().values();
    }

    public TownRelation getWorstRelationWith(ITanPlayer player) {
        TownRelation worstRelation = null;
        for (TerritoryData territoryData : player.getAllTerritoriesPlayerIsIn()) {
            TownRelation actualRelation = this.getRelationWith(territoryData);
            if (worstRelation != null && !worstRelation.isSuperiorTo(actualRelation)) continue;
            worstRelation = actualRelation;
        }
        if (worstRelation == null) {
            return TownRelation.NEUTRAL;
        }
        return worstRelation;
    }

    public TownRelation getRelationWith(TerritoryData territoryData) {
        return this.getRelationWith(territoryData.getID());
    }

    public TownRelation getRelationWith(String territoryID) {
        if (this.getID().equals(territoryID)) {
            return TownRelation.SELF;
        }
        Optional<TerritoryData> overlord = this.getOverlord();
        if (overlord.isPresent() && overlord.get().getID().equals(territoryID)) {
            return TownRelation.OVERLORD;
        }
        if (this.getVassalsID().contains(territoryID)) {
            return TownRelation.VASSAL;
        }
        return this.getRelations().getRelationWith(territoryID);
    }

    public long getCreationDate() {
        return this.dateTimeCreated;
    }

    public abstract void broadCastMessage(FilledLang var1);

    public abstract void broadcastMessageWithSound(FilledLang var1, SoundEnum var2, boolean var3);

    public abstract void broadcastMessageWithSound(FilledLang var1, SoundEnum var2);

    public abstract boolean haveNoLeader();

    public abstract IconBuilder getIconWithInformations(LangType var1);

    public IconBuilder getIconWithInformationAndRelation(TerritoryData territoryData, LangType langType) {
        IconBuilder icon = this.getIconWithInformations(langType);
        TownRelation relation = this.getRelationWith(territoryData);
        return icon.addDescription(Lang.GUI_TOWN_INFO_TOWN_RELATION.get(relation.getColoredName(langType)));
    }

    public Collection<String> getAttacksInvolvedID() {
        if (this.attackIncomingList == null) {
            this.attackIncomingList = new ArrayList<String>();
        }
        return this.attackIncomingList;
    }

    public void addPlannedAttack(PlannedAttack war) {
        this.getAttacksInvolvedID().add(war.getID());
    }

    public void removePlannedAttack(PlannedAttack war) {
        this.getAttacksInvolvedID().remove(war.getID());
    }

    public Collection<CurrentAttack> getCurrentAttacks() {
        ArrayList<CurrentAttack> res = new ArrayList<CurrentAttack>();
        for (String attackID : this.getAttacksInvolvedID()) {
            CurrentAttack attackInvolved = CurrentAttacksStorage.get(attackID);
            if (attackInvolved == null) continue;
            res.add(attackInvolved);
        }
        return res;
    }

    public void removeCurrentAttack(CurrentAttack currentAttacks) {
        this.getAttacksInvolvedID().remove(currentAttacks.getAttackData().getID());
    }

    public double getBalance() {
        if (this.treasury == null) {
            this.treasury = 0.0;
        }
        return this.treasury;
    }

    public void addToBalance(double balance) {
        this.treasury = this.treasury + balance;
    }

    public void removeFromBalance(double balance) {
        this.treasury = this.treasury - balance;
    }

    public void setOverlord(TerritoryData overlord) {
        this.getOverlordsProposals().remove(overlord.getID());
        this.broadcastMessageWithSound(Lang.ACCEPTED_VASSALISATION_PROPOSAL_ALL.get(this.getBaseColoredName(), overlord.getBaseColoredName()), SoundEnum.GOOD);
        this.overlordID = overlord.getID();
        overlord.addVassal(this);
    }

    public Optional<TerritoryData> getOverlord() {
        if (this.overlordID == null) {
            return Optional.empty();
        }
        TerritoryData overlord = TerritoryUtil.getTerritory(this.overlordID);
        if (overlord == null) {
            this.overlordID = null;
            return Optional.empty();
        }
        return Optional.of(overlord);
    }

    protected abstract Collection<TerritoryData> getOverlords();

    public void removeOverlord() {
        this.getOverlord().ifPresent(overlord -> {
            overlord.removeVassal(this);
            this.removeOverlordPrivate();
            this.overlordID = null;
        });
    }

    public abstract void removeOverlordPrivate();

    public void addVassal(TerritoryData vassal) {
        EventManager.getInstance().callEvent(new TerritoryVassalAcceptedInternalEvent(vassal, this));
        this.addVassalPrivate(vassal);
    }

    protected abstract void addVassalPrivate(TerritoryData var1);

    protected abstract void removeVassal(TerritoryData var1);

    public boolean isCapital() {
        Optional<TerritoryData> capital = this.getOverlord();
        return capital.map(overlord -> Objects.equals(overlord.getCapital().getID(), this.getID())).orElse(false);
    }

    public abstract TerritoryData getCapital();

    public int getChunkColorCode() {
        if (this.color == null) {
            this.color = StringUtil.randomColor();
        }
        return this.color;
    }

    public String getChunkColorInHex() {
        return String.format("#%06X", this.getChunkColorCode());
    }

    public ChatColor getChunkColor() {
        return ChatColor.of((String)this.getChunkColorInHex());
    }

    public void setChunkColor(int color) {
        this.color = color;
        this.applyToAllOnlinePlayer(PrefixUtil::updatePrefix);
    }

    public boolean haveOverlord() {
        return this.getOverlord().isPresent();
    }

    public Map<String, Integer> getAvailableEnemyClaims() {
        if (this.availableClaims == null) {
            this.availableClaims = new HashMap();
        }
        return this.availableClaims;
    }

    public void addAvailableClaims(String territoryID, int amount) {
        this.getAvailableEnemyClaims().merge(territoryID, amount, Integer::sum);
    }

    public void consumeEnemyClaim(String territoryID) {
        this.getAvailableEnemyClaims().merge(territoryID, -1, Integer::sum);
        if (this.getAvailableEnemyClaims().get(territoryID) <= 0) {
            this.getAvailableEnemyClaims().remove(territoryID);
        }
    }

    public boolean claimChunk(Player player) {
        return this.claimChunk(player, player.getLocation().getChunk());
    }

    public boolean claimChunk(Player player, Chunk chunk) {
        return this.claimChunk(player, chunk, Constants.allowNonAdjacentChunksFor(this));
    }

    public boolean claimChunk(Player player, Chunk chunk, boolean ignoreAdjacent) {
        FilledLang message;
        if (!this.canClaimChunk(player, chunk, ignoreAdjacent)) {
            return false;
        }
        this.abstractClaimChunk(player, chunk, ignoreAdjacent);
        ChunkCap chunkCap = this.getNewLevel().getStat(ChunkCap.class);
        if (chunkCap.isUnlimited()) {
            message = Lang.CHUNK_CLAIMED_SUCCESS_UNLIMITED.get(this.getColoredName());
        } else {
            String currentAmountOfChunks = Integer.toString(this.getNumberOfClaimedChunk());
            String maxAmountOfChunks = Integer.toString(chunkCap.getMaxAmount());
            message = Lang.CHUNK_CLAIMED_SUCCESS_LIMITED.get(this.getColoredName(), currentAmountOfChunks, maxAmountOfChunks);
        }
        TanChatUtils.message((CommandSender)player, message);
        return true;
    }

    protected abstract void abstractClaimChunk(Player var1, Chunk var2, boolean var3);

    public boolean canClaimChunk(Player player, Chunk chunk, boolean ignoreAdjacent) {
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        if (ClaimBlacklistStorage.cannotBeClaimed(chunk)) {
            TanChatUtils.message(player, Lang.CHUNK_IS_BLACKLISTED.get(player));
            return false;
        }
        if (!this.doesPlayerHavePermission(tanPlayer, RolePermission.CLAIM_CHUNK)) {
            TanChatUtils.message(player, Lang.PLAYER_NO_PERMISSION.get(player));
            return false;
        }
        TerritoryStats territoryStats = this.getNewLevel();
        int nbOfClaimedChunks = this.getNumberOfClaimedChunk();
        if (!territoryStats.getStat(BiomeStat.class).canClaimBiome(chunk)) {
            TanChatUtils.message(player, Lang.CHUNK_BIOME_NOT_ALLOWED.get(player));
            return false;
        }
        if (!territoryStats.getStat(ChunkCap.class).canDoAction(nbOfClaimedChunks)) {
            TanChatUtils.message(player, Lang.MAX_CHUNK_LIMIT_REACHED.get(player));
            return false;
        }
        int cost = this.getClaimCost();
        if (this.getBalance() < (double)cost) {
            TanChatUtils.message(player, Lang.TERRITORY_NOT_ENOUGH_MONEY.get(player, this.getColoredName(), Double.toString((double)cost - this.getBalance())));
            return false;
        }
        ClaimedChunk2 chunkData = NewClaimedChunkStorage.getInstance().get(chunk);
        if (!chunkData.canTerritoryClaim(player, this)) {
            return false;
        }
        if (ignoreAdjacent) {
            return true;
        }
        if (this.getNumberOfClaimedChunk() == 0) {
            if (ChunkUtil.isInBufferZone(chunkData, this)) {
                TanChatUtils.message(player, Lang.CHUNK_IN_BUFFER_ZONE.get(player, Integer.toString(Constants.territoryClaimBufferZone())));
                return false;
            }
            return true;
        }
        if (!NewClaimedChunkStorage.getInstance().isOneAdjacentChunkClaimedBySameTerritory(chunk, this.getID())) {
            TanChatUtils.message(player, Lang.CHUNK_NOT_ADJACENT.get(player));
            return false;
        }
        return true;
    }

    public int getClaimCost() {
        return this.getNewLevel().getStat(ChunkCost.class).getCost();
    }

    public synchronized void delete() {
        NewClaimedChunkStorage.getInstance().unclaimAllChunksFromTerritory(this);
        this.applyToAllOnlinePlayer(HumanEntity::closeInventory);
        for (TerritoryData territory : this.getVassals()) {
            territory.removeOverlord();
        }
        for (Fort occupiedFort : this.getOccupiedForts()) {
            occupiedFort.liberate();
        }
        for (Fort ownedFort : this.getOwnedForts()) {
            FortStorage.getInstance().delete(ownedFort);
        }
        this.getRelations().cleanAll(this);
        PlannedAttackStorage.getInstance().territoryDeleted(this);
    }

    public boolean canConquerChunk(ClaimedChunk2 chunk) {
        if (this.getAvailableEnemyClaims().containsKey(chunk.getOwnerID())) {
            this.consumeEnemyClaim(chunk.getOwnerID());
            return true;
        }
        return false;
    }

    public void addDonation(Player player, double amount) {
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        double playerBalance = EconomyUtil.getBalance(player);
        if (playerBalance < amount) {
            TanChatUtils.message(player, Lang.PLAYER_NOT_ENOUGH_MONEY.get(langType, new String[0]));
            return;
        }
        if (amount <= 0.0) {
            TanChatUtils.message(player, Lang.PAY_MINIMUM_REQUIRED.get(langType, new String[0]));
            return;
        }
        EconomyUtil.removeFromBalance(player, amount);
        this.addToBalance(amount);
        TransactionManager.getInstance().register(new DonationTransaction(this, player, amount));
        TanChatUtils.message(player, Lang.PLAYER_SEND_MONEY_SUCCESS.get(langType, Double.toString(amount), this.getBaseColoredName()), SoundEnum.MINOR_GOOD);
    }

    public abstract void openMainMenu(Player var1);

    public abstract boolean canHaveVassals();

    public abstract boolean canHaveOverlord();

    public abstract List<String> getVassalsID();

    public List<TerritoryData> getVassals() {
        ArrayList<TerritoryData> res = new ArrayList<TerritoryData>();
        for (String vassalID : this.getVassalsID()) {
            TerritoryData vassal = TerritoryUtil.getTerritory(vassalID);
            if (vassal == null) continue;
            res.add(vassal);
        }
        return res;
    }

    public int getVassalCount() {
        return this.getVassalsID().size();
    }

    public boolean isVassal(TerritoryData territoryData) {
        return this.isVassal(territoryData.getID());
    }

    public abstract boolean isVassal(String var1);

    public abstract Collection<TerritoryData> getPotentialVassals();

    private List<String> getOverlordsProposals() {
        if (this.overlordsProposals == null) {
            this.overlordsProposals = new ArrayList<String>();
        }
        return this.overlordsProposals;
    }

    public void addVassalisationProposal(TerritoryData proposal) {
        this.getOverlordsProposals().add(proposal.getID());
        this.broadcastMessageWithSound(Lang.REGION_DIPLOMATIC_INVITATION_RECEIVED_1.get(proposal.getBaseColoredName(), this.getBaseColoredName()), SoundEnum.MINOR_GOOD);
        EventManager.getInstance().callEvent(new TerritoryVassalProposalInternalEvent(proposal, this));
    }

    public void removeVassalisationProposal(TerritoryData proposal) {
        this.getOverlordsProposals().remove(proposal.getID());
    }

    public boolean containsVassalisationProposal(TerritoryData proposal) {
        return this.getOverlordsProposals().contains(proposal.getID());
    }

    public int getNumberOfVassalisationProposals() {
        return this.getOverlordsProposals().size();
    }

    public List<GuiItem> getAllSubjugationProposals(Player player, int page) {
        ArrayList<GuiItem> proposals = new ArrayList<GuiItem>();
        ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(player);
        LangType langType = tanPlayer.getLang();
        for (String proposalID : this.getOverlordsProposals()) {
            TerritoryData proposalOverlord = TerritoryUtil.getTerritory(proposalID);
            if (proposalOverlord == null) continue;
            proposals.add(proposalOverlord.getIconWithInformations(langType).setClickToAcceptMessage(Lang.GUI_GENERIC_LEFT_CLICK_TO_ACCEPT, Lang.RIGHT_CLICK_TO_REFUSE).setAction(action -> {
                if (action.isLeftClick()) {
                    if (this.haveOverlord()) {
                        TanChatUtils.message(player, Lang.TOWN_ALREADY_HAVE_OVERLORD.get(langType, new String[0]), SoundEnum.NOT_ALLOWED);
                        return;
                    }
                    this.setOverlord(proposalOverlord);
                    this.broadcastMessageWithSound(Lang.ACCEPTED_VASSALISATION_PROPOSAL_ALL.get(this.getBaseColoredName(), proposalOverlord.getName()), SoundEnum.GOOD);
                    PlayerGUI.openHierarchyMenu(player, this);
                } else if (action.isRightClick()) {
                    this.getOverlordsProposals().remove(proposalID);
                    PlayerGUI.openChooseOverlordMenu(player, this, page);
                }
            }).asGuiItem(player, langType));
        }
        return proposals;
    }

    protected Map<Integer, RankData> getRanks() {
        if (this.ranks == null) {
            this.ranks = new HashMap<Integer, RankData>();
        }
        return this.ranks;
    }

    public Collection<RankData> getAllRanks() {
        return this.getRanks().values();
    }

    public Collection<RankData> getAllRanksSorted() {
        return this.getRanks().values().stream().sorted(Comparator.comparingInt(p -> -p.getLevel())).toList();
    }

    public RankData getRank(int rankID) {
        return this.getRanks().get(rankID);
    }

    public abstract RankData getRank(ITanPlayer var1);

    public RankData getRank(Player player) {
        return this.getRank(PlayerDataStorage.getInstance().get(player));
    }

    public int getNumberOfRank() {
        return this.getRanks().size();
    }

    public boolean isRankNameUsed(String message) {
        for (RankData rank : this.getAllRanks()) {
            if (!rank.getName().equals(message)) continue;
            return true;
        }
        return false;
    }

    public RankData registerNewRank(String rankName) {
        int nextRankId = 0;
        for (RankData rank : this.getAllRanks()) {
            if (rank.getID() < nextRankId) continue;
            nextRankId = rank.getID() + 1;
        }
        RankData newRank = new RankData(nextRankId, rankName);
        this.getRanks().put(nextRankId, newRank);
        return newRank;
    }

    public void removeRank(int key) {
        this.getRanks().remove(key);
    }

    public int getDefaultRankID() {
        if (this.defaultRankID == null) {
            this.defaultRankID = this.getAllRanks().iterator().next().getID();
        }
        return this.defaultRankID;
    }

    public void setDefaultRank(RankData rank) {
        this.setDefaultRank(rank.getID());
    }

    public void setDefaultRank(int rankID) {
        this.defaultRankID = rankID;
    }

    public abstract List<GuiItem> getOrderedMemberList(ITanPlayer var1);

    public boolean doesPlayerHavePermission(Player player, RolePermission townRolePermission) {
        return this.doesPlayerHavePermission(PlayerDataStorage.getInstance().get(player), townRolePermission);
    }

    public boolean doesPlayerHavePermission(ITanPlayer tanPlayer, RolePermission townRolePermission) {
        if (!this.isPlayerIn(tanPlayer)) {
            return false;
        }
        if (this.isLeader(tanPlayer)) {
            return true;
        }
        return this.getRank(tanPlayer).hasPermission(townRolePermission);
    }

    public void setPlayerRank(ITanPlayer playerStat, RankData rankData) {
        this.getRank(playerStat).removePlayer(playerStat);
        rankData.addPlayer(playerStat);
        this.specificSetPlayerRank(playerStat, rankData.getID());
    }

    protected abstract void specificSetPlayerRank(ITanPlayer var1, int var2);

    public Budget getBudget() {
        Budget budget = new Budget();
        this.addCommonTaxes(budget);
        this.addSpecificTaxes(budget);
        return budget;
    }

    private void addCommonTaxes(Budget budget) {
        budget.addProfitLine(new SalaryPaymentLine(this));
        budget.addProfitLine(new ChunkUpkeepLine(this));
    }

    protected abstract void addSpecificTaxes(Budget var1);

    public int getNumberOfClaimedChunk() {
        return NewClaimedChunkStorage.getInstance().getAllChunkFrom(this).size();
    }

    public double getTax() {
        if (this.baseTax == null) {
            this.baseTax = 0.0;
        }
        return this.baseTax;
    }

    public void setTax(double newTax) {
        this.baseTax = newTax;
    }

    public void addToTax(double i) {
        this.setTax(this.getTax() + i);
    }

    public void executeTasks() {
        this.collectTaxes();
        this.paySalaries();
        this.payChunkUpkeep();
    }

    private void paySalaries() {
        for (RankData rank : this.getAllRanks()) {
            int rankSalary = rank.getSalary();
            List<String> playerIdList = rank.getPlayersID();
            double costOfSalary = (double)playerIdList.size() * (double)rankSalary;
            if (rankSalary == 0 || costOfSalary > this.getBalance()) continue;
            this.removeFromBalance(costOfSalary);
            for (String playerId : playerIdList) {
                ITanPlayer tanPlayer = PlayerDataStorage.getInstance().get(playerId);
                EconomyUtil.addFromBalance(tanPlayer, (double)rankSalary);
                TransactionManager.getInstance().register(new SalaryTransaction(this.getID(), playerId, costOfSalary));
            }
        }
    }

    private void payChunkUpkeep() {
        double upkeepCost = Constants.getUpkeepCost(this);
        int numberClaimedChunk = this.getNumberOfClaimedChunk();
        double totalUpkeep = (double)numberClaimedChunk * upkeepCost;
        if (totalUpkeep > this.getBalance()) {
            this.deletePortionOfChunk();
        } else {
            this.removeFromBalance(totalUpkeep);
        }
    }

    private void deletePortionOfChunk() {
        int minNbOfUnclaimedChunk = Constants.getMinimumNumberOfChunksUnclaimed();
        int nbOfUnclaimedChunk = 0;
        double percentageOfChunkToKeep = Constants.getPercentageOfChunksUnclaimed();
        List<ClaimedChunk2> borderChunks = ChunkUtil.getBorderChunks(this);
        for (ClaimedChunk2 claimedChunk2 : borderChunks) {
            if (!(RandomUtil.getRandom().nextDouble() < percentageOfChunkToKeep)) continue;
            NewClaimedChunkStorage.getInstance().unclaimChunkAndUpdate(claimedChunk2);
            ++nbOfUnclaimedChunk;
        }
        if (nbOfUnclaimedChunk < minNbOfUnclaimedChunk) {
            for (ClaimedChunk2 claimedChunk2 : borderChunks) {
                NewClaimedChunkStorage.getInstance().unclaimChunkAndUpdate(claimedChunk2);
                if (++nbOfUnclaimedChunk < minNbOfUnclaimedChunk) continue;
                break;
            }
        }
    }

    protected abstract void collectTaxes();

    public double getTaxOnRentingProperty() {
        if (this.propertyRentTax > 1.0) {
            this.propertyRentTax = 1.0;
        }
        return this.propertyRentTax;
    }

    public void setTaxOnRentingProperty(double amount) {
        this.propertyRentTax = amount;
    }

    public double getTaxOnBuyingProperty() {
        if (this.propertyBuyTax > 1.0) {
            this.propertyBuyTax = 1.0;
        }
        return this.propertyBuyTax;
    }

    public void setTaxOnBuyingProperty(double amount) {
        this.propertyBuyTax = amount;
    }

    public double getTaxOnCreatingProperty() {
        return this.propertyCreateTax;
    }

    public void setTaxOnCreatingProperty(double amount) {
        this.propertyCreateTax = amount;
    }

    public boolean isAtWar() {
        return !this.getCurrentAttacks().isEmpty();
    }

    public ChunkPermission getPermission(ChunkPermissionType type) {
        return this.getChunkSettings().getPermission(type);
    }

    public void nextPermission(ChunkPermissionType type) {
        this.getChunkSettings().nextPermission(type);
    }

    protected RankData getDefaultRank() {
        return this.getRank(this.getDefaultRankID());
    }

    protected void registerPlayer(ITanPlayer tanPlayer) {
        this.getDefaultRank().addPlayer(tanPlayer);
        tanPlayer.setRankID(this, this.getDefaultRankID());
    }

    protected void unregisterPlayer(ITanPlayer tanPlayer) {
        this.getRank(tanPlayer).removePlayer(tanPlayer);
        tanPlayer.setRankID(this, null);
    }

    public String getColoredName() {
        if (Constants.displayTerritoryColor()) {
            return this.getCustomColoredName().getText();
        }
        return this.getBaseColoredName();
    }

    public String getLeaderName() {
        if (this.haveNoLeader()) {
            return Lang.NO_LEADER.getDefault();
        }
        return this.getLeaderData().getNameStored();
    }

    public void registerFort(Vector3D location) {
        Fort fort = FortStorage.getInstance().register(location, this);
        Vector3D flagPosition = fort.getPosition();
        flagPosition.getWorld().getChunkAt(flagPosition.getX(), flagPosition.getZ());
        this.addOwnedFort(fort);
    }

    public List<String> getOwnedFortIDs() {
        if (this.fortIds == null) {
            this.fortIds = new ArrayList<String>();
        }
        return this.fortIds;
    }

    public List<String> getOccupiedFortIds() {
        if (this.occupiedFortIds == null) {
            this.occupiedFortIds = new ArrayList<String>();
        }
        return this.occupiedFortIds;
    }

    public void removeOccupiedFort(Fort fort) {
        this.removeOccupiedFortID(fort.getID());
    }

    public void removeOccupiedFortID(String fortID) {
        this.getOccupiedFortIds().remove(fortID);
    }

    public void addOccupiedFort(Fort fort) {
        this.addOccupiedFortID(fort.getID());
    }

    public void addOccupiedFortID(String fortID) {
        this.getOccupiedFortIds().add(fortID);
    }

    public List<Fort> getOwnedForts() {
        return FortStorage.getInstance().getOwnedFort(this);
    }

    public List<Fort> getOccupiedForts() {
        return FortStorage.getInstance().getOccupiedFort(this);
    }

    public List<Fort> getAllControlledFort() {
        return FortStorage.getInstance().getAllControlledFort(this);
    }

    public void removeFort(String fortID) {
        this.getOwnedFortIDs().remove(fortID);
    }

    public Collection<Building> getBuildings() {
        ArrayList<Building> buildings = new ArrayList<Building>(this.getOwnedForts());
        TerritoryData territoryData = this;
        if (territoryData instanceof TownData) {
            TownData townData = (TownData)territoryData;
            buildings.addAll(townData.getProperties());
        }
        buildings.removeAll(Collections.singleton(null));
        return buildings;
    }

    public void addOwnedFort(Fort fortToCapture) {
        if (fortToCapture == null) {
            return;
        }
        this.getOwnedFortIDs().add(fortToCapture.getID());
    }

    public void removeOwnedFort(Fort fortToCapture) {
        if (fortToCapture == null) {
            return;
        }
        this.getOwnedFortIDs().remove(fortToCapture.getID());
    }

    public void applyToAllOnlinePlayer(Consumer<Player> action) {
        for (Player player : this.getPlayers()) {
            action.accept(player);
        }
    }

    private List<Player> getPlayers() {
        ArrayList<Player> playerList = new ArrayList<Player>();
        for (String playerID : this.getPlayerIDList()) {
            Player player = Bukkit.getPlayer((UUID)UUID.fromString(playerID));
            if (player == null) continue;
            playerList.add(player);
        }
        return playerList;
    }

    public boolean canAccessBufferZone(TerritoryChunk territoryChunk) {
        String ownerID = territoryChunk.getOwnerID();
        if (ownerID.equals(this.id)) {
            return true;
        }
        Optional<TerritoryData> optCapital = this.getOverlord();
        if (optCapital.isPresent()) {
            TerritoryData capital = optCapital.get();
            return ownerID.equals(capital.getID());
        }
        return false;
    }

    public TerritoryStats getNewLevel() {
        if (this.upgradesStatus == null) {
            TerritoryData territoryData = this;
            if (territoryData instanceof TownData) {
                TownData townData = (TownData)territoryData;
                if (townData.townLevel != null) {
                    this.upgradesStatus = new TerritoryStats(townData.townLevel);
                    townData.townLevel = null;
                } else {
                    this.upgradesStatus = new TerritoryStats(StatsType.TOWN);
                }
            } else {
                this.upgradesStatus = new TerritoryStats(StatsType.REGION);
            }
        }
        return this.upgradesStatus;
    }
}

