/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.leralix.lib.utils.config.ConfigTag;
import org.leralix.lib.utils.config.ConfigUtil;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.events.newsletter.EventScope;
import org.leralix.tan.events.newsletter.NewsletterScope;
import org.leralix.tan.events.newsletter.dao.NewsletterDAO;
import org.leralix.tan.events.newsletter.news.Newsletter;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.PlayerDataStorage;

public class NewsletterStorage {
    private final NewsletterDAO newsletterDAO = new NewsletterDAO(TownsAndNations.getPlugin().getDatabaseHandler().getDataSource());
    private static NewsletterStorage instance;

    private NewsletterStorage() {
    }

    public static NewsletterStorage getInstance() {
        if (instance == null) {
            instance = new NewsletterStorage();
            instance.clearOldNewsletters();
        }
        return instance;
    }

    public NewsletterDAO getNewsletterDAO() {
        return this.newsletterDAO;
    }

    public void register(Newsletter newsletter) {
        EventScope scope = newsletter.getType().getBroadcastGlobal();
        if (scope != EventScope.NONE) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                try {
                    if (scope == EventScope.CONCERNED && newsletter.shouldShowToPlayer(player)) {
                        newsletter.broadcastConcerned(player);
                        continue;
                    }
                    if (scope != EventScope.ALL) continue;
                    newsletter.broadcast(player);
                }
                catch (Exception e) {
                    Bukkit.getLogger().warning("Error while delivering newsletter to " + player.getName() + ": " + e.getMessage());
                    break;
                }
            }
        }
        try {
            this.newsletterDAO.save(newsletter);
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("Error while saving newsletter: " + e.getMessage());
        }
    }

    private List<Newsletter> getNewsletters() {
        return this.newsletterDAO.getNewsletters();
    }

    public List<GuiItem> getNewsletterForPlayer(Player player, NewsletterScope scope, Consumer<Player> onClick) {
        ArrayList<GuiItem> newsletters = new ArrayList<GuiItem>();
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        for (Newsletter newsletter : this.getNewsletters()) {
            EventScope eventScope = newsletter.getType().getNewsletterScope();
            if (eventScope == EventScope.NONE) continue;
            if (eventScope == EventScope.CONCERNED && newsletter.shouldShowToPlayer(player)) {
                if (scope == NewsletterScope.SHOW_ALL) {
                    newsletters.add(newsletter.createConcernedGuiItem(player, langType, onClick));
                    continue;
                }
                if (scope == NewsletterScope.SHOW_ONLY_UNREAD && !newsletter.isRead(player)) {
                    newsletters.add(newsletter.createGuiItem(player, langType, onClick));
                    continue;
                }
            }
            if (eventScope != EventScope.ALL) continue;
            if (scope == NewsletterScope.SHOW_ALL) {
                newsletters.add(newsletter.createGuiItem(player, langType, onClick));
                continue;
            }
            if (scope != NewsletterScope.SHOW_ONLY_UNREAD || newsletter.isRead(player)) continue;
            newsletters.add(newsletter.createGuiItem(player, langType, onClick));
        }
        newsletters.removeAll(Collections.singleton(null));
        return newsletters;
    }

    public int getNbUnreadNewsletterForPlayer(Player player) {
        return this.getNewsletterForPlayer(player, NewsletterScope.SHOW_ONLY_UNREAD, null).size();
    }

    public void clearOldNewsletters() {
        int nbDays = ConfigUtil.getCustomConfig((ConfigTag)ConfigTag.MAIN).getInt("TimeBeforeClearingNewsletter");
        this.newsletterDAO.deleteOldNewsletters(nbDays);
    }

    public void markAllAsReadForPlayer(Player player) {
        this.getNewsletterDAO().markAllAsRead(player);
    }
}

