/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.DataSource;
import org.leralix.tan.events.newsletter.dao.NewsletterSubDAO;
import org.leralix.tan.events.newsletter.news.AttackWonByAttackerNewsletter;

public class AttackWonByAttackerDAO
extends NewsletterSubDAO<AttackWonByAttackerNewsletter> {
    private static final String TABLE_NAME = "attack_won_by_attackers_newsletter";

    public AttackWonByAttackerDAO(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected void createTableIfNotExists() {
        String sql = "CREATE TABLE IF NOT EXISTS attack_won_by_attackers_newsletter (id VARCHAR(36) PRIMARY KEY, attackingTerritoryID VARCHAR(36) NOT NULL, defendingTerritoryID VARCHAR(36) NOT NULL)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create player diplomacy accepted newsletter table", e);
        }
    }

    @Override
    public void save(AttackWonByAttackerNewsletter newsletter, Connection conn) {
        String sql = "INSERT INTO attack_won_by_attackers_newsletter (id, attackingTerritoryID, defendingTerritoryID) VALUES (?, ?, ?)";
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, newsletter.getId());
            ps.setString(2, newsletter.getAttackingTerritoryID());
            ps.setString(3, newsletter.getDefendingTerritoryID());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to save player application newsletter", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AttackWonByAttackerNewsletter load(UUID id, long date, Connection conn) {
        String sql = "SELECT attackingTerritoryID, defendingTerritoryID FROM attack_won_by_attackers_newsletter WHERE id = ?";
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                String attackingTerritoryID = rs.getString("attackingTerritoryID");
                String defendingTerritoryID = rs.getString("defendingTerritoryID");
                AttackWonByAttackerNewsletter attackWonByAttackerNewsletter = new AttackWonByAttackerNewsletter(id, date, attackingTerritoryID, defendingTerritoryID);
                return attackWonByAttackerNewsletter;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to load player application newsletter", e);
        }
    }

    @Override
    public void delete(UUID id) {
        String sql = "DELETE FROM attack_won_by_attackers_newsletter WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to delete from table attack_won_by_attackers_newsletter", e);
        }
    }
}

