/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.DataSource;
import org.leralix.tan.enums.TownRelation;
import org.leralix.tan.events.newsletter.dao.NewsletterSubDAO;
import org.leralix.tan.events.newsletter.news.DiplomacyAcceptedNews;

public class DiplomacyAcceptedDAO
extends NewsletterSubDAO<DiplomacyAcceptedNews> {
    private static final String TABLE_NAME = "diplomacy_accepted_newsletter";

    public DiplomacyAcceptedDAO(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected void createTableIfNotExists() {
        String sql = "CREATE TABLE IF NOT EXISTS diplomacy_accepted_newsletter (id VARCHAR(36) PRIMARY KEY, proposingTerritoryID VARCHAR(36) NOT NULL, receivingTerritoryID VARCHAR(36) NOT NULL, wantedRelation VARCHAR(36) NOT NULL, isWorseRelation BOOLEAN NOT NULL)";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create player diplomacy accepted newsletter table", e);
        }
    }

    @Override
    public void save(DiplomacyAcceptedNews newsletter, Connection conn) {
        String sql = "INSERT INTO diplomacy_accepted_newsletter (id, proposingTerritoryID, receivingTerritoryID, wantedRelation, isWorseRelation) VALUES (?, ?, ?, ?, ?)";
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, newsletter.getId());
            ps.setString(2, newsletter.getProposingTerritoryID());
            ps.setString(3, newsletter.getReceivingTerritoryID());
            ps.setString(4, newsletter.getWantedRelation().toString());
            ps.setBoolean(5, newsletter.isRelationWorse());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to save player application newsletter", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DiplomacyAcceptedNews load(UUID id, long date, Connection conn) {
        String sql = "SELECT proposingTerritoryID, receivingTerritoryID, wantedRelation, isWorseRelation FROM diplomacy_accepted_newsletter WHERE id = ?";
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                String proposingTerritoryID = rs.getString("proposingTerritoryID");
                String receivingTerritoryID = rs.getString("receivingTerritoryID");
                TownRelation wantedRelation = TownRelation.valueOf(rs.getString("wantedRelation"));
                boolean isRelationWorse = rs.getBoolean("isWorseRelation");
                DiplomacyAcceptedNews diplomacyAcceptedNews = new DiplomacyAcceptedNews(id, date, proposingTerritoryID, receivingTerritoryID, wantedRelation, isRelationWorse);
                return diplomacyAcceptedNews;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to load player application newsletter", e);
        }
    }

    @Override
    public void delete(UUID id) {
        String sql = "DELETE FROM diplomacy_accepted_newsletter WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to delete from table diplomacy_accepted_newsletter", e);
        }
    }
}

