/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import javax.sql.DataSource;
import org.leralix.tan.events.newsletter.dao.NewsletterSubDAO;
import org.leralix.tan.events.newsletter.news.LandmarkUnclaimedNewsletter;

public class LandmarkUnclaimedDAO
extends NewsletterSubDAO<LandmarkUnclaimedNewsletter> {
    private static final String TABLE_NAME = "landmark_unclaimed_newsletter";

    public LandmarkUnclaimedDAO(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected void createTableIfNotExists() {
        String sql = "CREATE TABLE IF NOT EXISTS landmark_unclaimed_newsletter (id VARCHAR(36) PRIMARY KEY, landmarkID VARCHAR(36) NOT NULL, oldOwnerID VARCHAR(36) NOT NULL )";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create diplomacy proposal newsletter table", e);
        }
    }

    @Override
    public void save(LandmarkUnclaimedNewsletter newsletter, Connection conn) throws SQLException {
        String sql = "INSERT INTO landmark_unclaimed_newsletter (id, landmarkID, oldOwnerID) VALUES (?, ?, ?)";
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, newsletter.getId());
            ps.setString(2, newsletter.getLandmarkID());
            ps.setString(3, newsletter.getOldOwnerID());
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to save diplomacy proposal newsletter", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LandmarkUnclaimedNewsletter load(UUID id, long date, Connection conn) throws SQLException {
        String sql = "SELECT landmarkID, oldOwnerID FROM landmark_unclaimed_newsletter WHERE id = ?";
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                String landmarkID = rs.getString("landmarkID");
                String oldOwnerID = rs.getString("oldOwnerID");
                LandmarkUnclaimedNewsletter landmarkUnclaimedNewsletter = new LandmarkUnclaimedNewsletter(id, date, landmarkID, oldOwnerID);
                return landmarkUnclaimedNewsletter;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to load diplomacy proposal newsletter", e);
        }
    }

    @Override
    public void delete(UUID uuid) {
        String sql = "DELETE FROM landmark_unclaimed_newsletter WHERE id = ?";
        try (Connection conn = this.dataSource.getConnection();
             PreparedStatement ps = conn.prepareStatement(sql);){
            ps.setObject(1, uuid);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to delete from table landmark_unclaimed_newsletter", e);
        }
    }
}

