/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.events.newsletter.news;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.UUID;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.events.newsletter.NewsletterType;
import org.leralix.tan.events.newsletter.news.Newsletter;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.timezone.TimeZoneManager;
import org.leralix.tan.utils.deprecated.HeadUtils;
import org.leralix.tan.utils.gameplay.TerritoryUtil;
import org.leralix.tan.utils.text.TanChatUtils;
import org.tan.api.interfaces.TanTerritory;

public class AttackCancelledByDefenderNewsletter
extends Newsletter {
    private final String attackingTerritoryID;
    private final String defendingTerritoryID;

    public AttackCancelledByDefenderNewsletter(TanTerritory defendingTerritory, TanTerritory attackingTerritory) {
        this.defendingTerritoryID = defendingTerritory.getID();
        this.attackingTerritoryID = attackingTerritory.getID();
    }

    public AttackCancelledByDefenderNewsletter(UUID id, long date, String attackingTerritoryID, String defendingTerritoryID) {
        super(id, date);
        this.attackingTerritoryID = attackingTerritoryID;
        this.defendingTerritoryID = defendingTerritoryID;
    }

    public String getAttackingTerritoryID() {
        return this.attackingTerritoryID;
    }

    public String getDefendingTerritoryID() {
        return this.defendingTerritoryID;
    }

    @Override
    public GuiItem createGuiItem(Player player, LangType lang, Consumer<Player> onClick) {
        TerritoryData attackingTerritory = TerritoryUtil.getTerritory(this.attackingTerritoryID);
        TerritoryData defendingTerritory = TerritoryUtil.getTerritory(this.defendingTerritoryID);
        if (attackingTerritory == null || defendingTerritory == null) {
            return null;
        }
        LangType langType = PlayerDataStorage.getInstance().get(player).getLang();
        ItemStack icon = HeadUtils.createCustomItemStack(Material.IRON_SWORD, Lang.ATTACK_CANCELLED_TITLE.get(langType, new String[0]), Lang.NEWSLETTER_DATE.get(langType, TimeZoneManager.getInstance().getRelativeTimeDescription(langType, this.getDate())), Lang.ATTACK_CANCELLED.get(langType, attackingTerritory.getBaseColoredName(), defendingTerritory.getBaseColoredName()), Lang.NEWSLETTER_RIGHT_CLICK_TO_MARK_AS_READ.get(langType, new String[0]));
        return ItemBuilder.from(icon).asGuiItem(event -> {
            event.setCancelled(true);
            if (event.isRightClick()) {
                this.markAsRead(player);
                onClick.accept(player);
            }
        });
    }

    @Override
    public GuiItem createConcernedGuiItem(Player player, LangType lang, Consumer<Player> onClick) {
        return this.createGuiItem(player, lang, onClick);
    }

    @Override
    public boolean shouldShowToPlayer(Player player) {
        TerritoryData attackingTerritory = TerritoryUtil.getTerritory(this.attackingTerritoryID);
        if (attackingTerritory == null) {
            return false;
        }
        TerritoryData defendingTerritory = TerritoryUtil.getTerritory(this.defendingTerritoryID);
        if (defendingTerritory == null) {
            return false;
        }
        return attackingTerritory.isPlayerIn(player) || defendingTerritory.isPlayerIn(player);
    }

    @Override
    public NewsletterType getType() {
        return NewsletterType.ATTACK_CANCELLED;
    }

    @Override
    public void broadcast(Player player) {
        TerritoryData attackingTerritory = TerritoryUtil.getTerritory(this.attackingTerritoryID);
        TerritoryData defendingTerritory = TerritoryUtil.getTerritory(this.defendingTerritoryID);
        if (attackingTerritory == null || defendingTerritory == null) {
            return;
        }
        TanChatUtils.message(player, Lang.DEFENSIVE_SIDE_HAS_SURRENDER.get(player, defendingTerritory.getBaseColoredName(), attackingTerritory.getBaseColoredName()), SoundEnum.WAR);
    }

    @Override
    public void broadcastConcerned(Player player) {
        this.broadcast(player);
    }
}

