/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.admin;

import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.Landmark;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.admin.AdminLandmarksMenu;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.PlayerChatListenerStorage;
import org.leralix.tan.listeners.chat.events.ChangeLandmarkName;
import org.leralix.tan.utils.constants.Constants;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class AdminLandmarkMenu
extends BasicGui {
    private final Landmark landmark;

    public AdminLandmarkMenu(Player player, Landmark landmark) {
        super(player, Lang.HEADER_ADMIN_SPECIFIC_LANDMARK_MENU.get(landmark.getName()), 3);
        this.landmark = landmark;
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(2, 3, this.getRenameLandmarkButton());
        this.gui.setItem(2, 5, this.getManageProductionButton());
        this.gui.setItem(2, 7, this.getDeleteLandmarkButton());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, p -> new AdminLandmarksMenu(this.player)));
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getDeleteLandmarkButton() {
        return this.iconManager.get(IconKey.DELETE_LANDMARK_ICON).setName(Lang.ADMIN_GUI_DELETE_LANDMARK.get(this.langType, new String[0])).setDescription(Lang.ADMIN_GUI_DELETE_LANDMARK_DESC1.get()).setAction(action -> {
            this.landmark.deleteLandmark();
            SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.MINOR_GOOD);
            new AdminLandmarksMenu(this.player);
        }).asGuiItem(this.player, this.langType);
    }

    @NotNull
    private GuiItem getManageProductionButton() {
        ItemStack ressources = this.landmark.getResources();
        return this.iconManager.get(ressources).setName(Lang.LANDMARK_PRODUCTION_NAME.get(this.langType, new String[0])).setDescription(Lang.SPECIFIC_LANDMARK_ICON_DESC1.get(Integer.toString(ressources.getAmount()), ressources.getType().name().toLowerCase())).setClickToAcceptMessage(Lang.SPECIFIC_LANDMARK_ICON_SWITCH_REWARD).setAction(action -> {
            ItemStack itemOnCursor = this.player.getItemOnCursor();
            if (itemOnCursor.getType() == Material.AIR) {
                return;
            }
            TanChatUtils.message(this.player, Lang.ADMIN_GUI_LANDMARK_REWARD_SET.get(this.player, Integer.toString(itemOnCursor.getAmount()), itemOnCursor.getType().name()), SoundEnum.GOOD);
            this.landmark.setReward(itemOnCursor);
            this.open();
        }).asGuiItem(this.player, this.langType);
    }

    @NotNull
    private GuiItem getRenameLandmarkButton() {
        return this.iconManager.get(IconKey.LANDMARK_RENAME_ICON).setName(Lang.ADMIN_GUI_CHANGE_LANDMARK_NAME.get(this.langType, new String[0])).setDescription(Lang.ADMIN_GUI_CHANGE_LANDMARK_NAME_DESC1.get()).setAction(action -> {
            TanChatUtils.message(this.player, Lang.ENTER_NEW_VALUE.get(this.player));
            PlayerChatListenerStorage.register(this.player, new ChangeLandmarkName(this.landmark, Constants.getLandmarkMaxNameSize(), p -> this.open()));
        }).asGuiItem(this.player, this.langType);
    }
}

