/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.admin;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.dataclass.Landmark;
import org.leralix.tan.dataclass.chunk.ClaimedChunk2;
import org.leralix.tan.dataclass.chunk.LandmarkClaimedChunk;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.admin.AdminLandmarkMenu;
import org.leralix.tan.gui.admin.AdminMainMenu;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.LandmarkStorage;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;
import org.leralix.tan.utils.deprecated.HeadUtils;
import org.leralix.tan.utils.text.TanChatUtils;

public class AdminLandmarksMenu
extends IteratorGUI {
    public AdminLandmarksMenu(Player player) {
        super(player, Lang.HEADER_ADMIN_LANDMARK_MENU, 6);
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getLandmarks(), p -> new AdminMainMenu(this.player));
        this.gui.setItem(6, 4, this.getAddLandmarkButton());
        this.gui.open((HumanEntity)this.player);
    }

    private GuiItem getAddLandmarkButton() {
        return this.iconManager.get(IconKey.CREATE_LANDMARK).setName(Lang.ADMIN_GUI_CREATE_LANDMARK.get(this.langType, new String[0])).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_PROCEED).setAction(action -> {
            ClaimedChunk2 claimedChunk = NewClaimedChunkStorage.getInstance().get(this.player.getLocation().getBlock().getChunk());
            if (claimedChunk instanceof LandmarkClaimedChunk) {
                TanChatUtils.message(this.player, Lang.ADMIN_CHUNK_ALREADY_LANDMARK.get(this.player));
                return;
            }
            Landmark newLandmark = LandmarkStorage.getInstance().addLandmark(this.player.getLocation());
            new AdminLandmarkMenu(this.player, newLandmark);
        }).asGuiItem(this.player, this.langType);
    }

    private List<GuiItem> getLandmarks() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (final Landmark landmark : LandmarkStorage.getInstance().getAll().values()) {
            ItemStack icon = landmark.getIcon(this.langType);
            HeadUtils.addLore(icon, "", Lang.CLICK_TO_OPEN_LANDMARK_MENU.get(this.langType, new String[0]), Lang.GUI_GENERIC_SHIFT_CLICK_TO_TELEPORT.get(this.langType, new String[0]));
            GuiItem item = ItemBuilder.from(icon).asGuiItem(event -> {
                event.setCancelled(true);
                if (!event.isShiftClick()) {
                    new AdminLandmarkMenu(this.player, landmark);
                } else {
                    new BukkitRunnable(){

                        public void run() {
                            AdminLandmarksMenu.this.player.closeInventory();
                            AdminLandmarksMenu.this.player.teleport(landmark.getLocation());
                        }
                    }.runTaskLater((Plugin)TownsAndNations.getPlugin(), 1L);
                    SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.GOOD);
                }
            });
            guiItems.add(item);
        }
        return guiItems;
    }
}

