/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.admin;

import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.economy.EconomyUtil;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.admin.AdminBrowsePlayers;
import org.leralix.tan.gui.admin.AdminSetPlayerTown;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.type.IconBuilder;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.StringUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class AdminManagePlayer
extends BasicGui {
    private final ITanPlayer targetPlayer;

    public AdminManagePlayer(Player player, ITanPlayer targetPlayer) {
        super(player, Lang.HEADER_ADMIN_PLAYER_MENU.get(targetPlayer.getNameStored()), 3);
        this.targetPlayer = targetPlayer;
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(1, 5, this.getPlayerInfo());
        this.gui.setItem(2, 2, this.getTownButton());
        this.gui.setItem(3, 1, GuiUtil.createBackArrow(this.player, p -> new AdminBrowsePlayers(this.player)));
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getTownButton() {
        IconBuilder iconBuilder = this.iconManager.get(IconKey.TOWN_BASE_ICON);
        if (this.tanPlayer.hasTown()) {
            TownData townData = this.tanPlayer.getTown();
            iconBuilder.setName(Lang.ADMIN_GUI_TOWN_PLAYER_TOWN.get(this.langType, townData.getName())).setClickToAcceptMessage(townData.isLeader(this.tanPlayer) ? Lang.ADMIN_GUI_TOWN_PLAYER_TOWN_DESC2 : Lang.ADMIN_GUI_TOWN_PLAYER_TOWN_DESC1).setAction(action -> {
                if (townData.isLeader(this.tanPlayer)) {
                    TanChatUtils.message(this.player, Lang.GUI_TOWN_MEMBER_CANT_KICK_LEADER.get(this.langType, new String[0]));
                    return;
                }
                townData.removePlayer(this.tanPlayer);
                TanChatUtils.message(this.player, Lang.ADMIN_GUI_TOWN_PLAYER_LEAVE_TOWN_SUCCESS.get(this.langType, this.tanPlayer.getNameStored(), townData.getName()));
                this.open();
            });
        } else {
            iconBuilder.setName(Lang.ADMIN_GUI_PLAYER_NO_TOWN.get(this.langType, new String[0])).setClickToAcceptMessage(Lang.GUI_GENERIC_ADD_BUTTON).setAction(action -> new AdminSetPlayerTown(this.player, this.tanPlayer));
        }
        return iconBuilder.asGuiItem(this.player, this.langType);
    }

    @NotNull
    private GuiItem getPlayerInfo() {
        OfflinePlayer offlinePlayer = this.targetPlayer.getOfflinePlayer();
        return this.iconManager.get(offlinePlayer).setName(offlinePlayer.getName()).setDescription(Lang.GUI_YOUR_BALANCE_DESC1.get(StringUtil.formatMoney(EconomyUtil.getBalance(offlinePlayer)))).asGuiItem(this.player, this.langType);
    }
}

