/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.admin;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.gui.admin.AdminManageTerritory;
import org.leralix.tan.gui.admin.AdminSelectNewOverlord;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.HeadUtils;
import org.leralix.tan.utils.text.TanChatUtils;

public class AdminManageTown
extends AdminManageTerritory {
    private final TownData townData;

    public AdminManageTown(Player player, TownData townData) {
        super(player, Lang.HEADER_ADMIN_SPECIFIC_REGION_MENU.get(townData.getName()), 3, townData);
        this.townData = townData;
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(2, 2, this.getRenameTerritory());
        this.gui.setItem(2, 3, this.getChangeDescription());
        this.gui.setItem(2, 4, this.changeLeader());
        this.gui.setItem(2, 5, this.getChangeRegion());
        this.gui.setItem(2, 6, this.getTransactionHistory());
        this.gui.setItem(2, 8, this.getDelete());
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getChangeRegion() {
        String name = this.townData.getOverlord().map(TerritoryData::getName).orElseGet(() -> Lang.NO_REGION.get(this.langType, new String[0]));
        ItemStack setRegionIcon = HeadUtils.makeSkullB64(name, "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDljMTgzMmU0ZWY1YzRhZDljNTE5ZDE5NGIxOTg1MDMwZDI1NzkxNDMzNGFhZjI3NDVjOWRmZDYxMWQ2ZDYxZCJ9fX0=");
        if (this.townData.haveOverlord()) {
            if (this.townData.isCapital()) {
                HeadUtils.addLore(setRegionIcon, Lang.GUI_CANNOT_QUIT_IF_LEADER.get(this.langType, new String[0]));
            } else {
                HeadUtils.addLore(setRegionIcon, Lang.GUI_RIGHT_CLICK_TO_QUIT.get(this.langType, new String[0]));
            }
        } else {
            HeadUtils.addLore(setRegionIcon, Lang.GUI_LEFT_CLICK_TO_SET_REGION.get(this.langType, new String[0]));
        }
        return ItemBuilder.from(setRegionIcon).asGuiItem(event -> {
            event.setCancelled(true);
            if (this.townData.haveOverlord()) {
                if (this.townData.isCapital()) {
                    TanChatUtils.message(this.player, Lang.GUI_CANNOT_QUIT_IF_LEADER.get(this.langType, new String[0]));
                } else {
                    this.townData.removeOverlord();
                    this.open();
                }
            } else {
                new AdminSelectNewOverlord(this.player, this.townData);
            }
        });
    }

    @NotNull
    private GuiItem changeLeader() {
        return null;
    }
}

