/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.admin;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.admin.AdminManageTown;
import org.leralix.tan.gui.cosmetic.type.IconBuilder;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.RegionDataStorage;

public class AdminSelectNewOverlord
extends IteratorGUI {
    private final TownData townData;

    public AdminSelectNewOverlord(Player player, TownData townData) {
        super(player, Lang.HEADER_ADMIN_CHANGE_OVERLORD.get(townData.getName()), 6);
        this.townData = townData;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getRegions(), p -> new AdminManageTown(this.player, this.townData));
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getRegions() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (TerritoryData potentialOverlord : RegionDataStorage.getInstance().getAll().values()) {
            IconBuilder potentialOverlordIcon = potentialOverlord.getIconWithInformations(this.tanPlayer.getLang());
            potentialOverlordIcon.addDescription(Lang.GUI_GENERIC_CLICK_TO_SELECT.get());
            potentialOverlordIcon.setAction(action -> {
                this.townData.setOverlord(potentialOverlord);
                new AdminManageTown(this.player, this.townData);
            });
            guiItems.add(potentialOverlordIcon.asGuiItem(this.player, this.langType));
        }
        return guiItems;
    }
}

