/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.admin;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.admin.AdminManagePlayer;
import org.leralix.tan.gui.cosmetic.type.IconBuilder;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.TownDataStorage;

public class AdminSetPlayerTown
extends IteratorGUI {
    private final ITanPlayer targetPlayer;

    public AdminSetPlayerTown(Player player, ITanPlayer tanPlayer) {
        super(player, Lang.HEADER_ADMIN_SET_PLAYER_TOWN, 6);
        this.targetPlayer = tanPlayer;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getTowns(), p -> new AdminManagePlayer(this.player, this.tanPlayer));
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getTowns() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (TownData townData : TownDataStorage.getInstance().getAll().values()) {
            IconBuilder townIcon = townData.getIconWithInformations(this.targetPlayer.getLang());
            townIcon.setClickToAcceptMessage(Lang.ADMIN_GUI_LEFT_CLICK_TO_MANAGE_TOWN);
            townIcon.setAction(action -> {
                townData.addPlayer(this.targetPlayer);
                new AdminManagePlayer(this.player, this.targetPlayer);
            });
            guiItems.add(townIcon.asGuiItem(this.player, this.langType));
        }
        return guiItems;
    }
}

