/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.service.requirements;

import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.service.requirements.IndividualRequirement;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.upgrade.rewards.bool.BooleanStat;

public class BooleanStatRequirement<T extends BooleanStat>
extends IndividualRequirement {
    private final TerritoryData territoryData;
    private final Class<T> statClass;

    public BooleanStatRequirement(TerritoryData territoryData, Class<T> statClass) {
        this.territoryData = territoryData;
        this.statClass = statClass;
    }

    @Override
    public String getLine(LangType langType) {
        Lang statName = ((BooleanStat)this.territoryData.getNewLevel().getStat(this.statClass)).getStatName();
        if (this.isInvalid()) {
            return Lang.REQUIREMENT_UPGRADE_NEGATIVE.get(langType, statName.get(langType, new String[0]));
        }
        return Lang.REQUIREMENT_UPGRADE_POSITIVE.get(langType, statName.get(langType, new String[0]));
    }

    @Override
    public boolean isInvalid() {
        return !((BooleanStat)this.territoryData.getNewLevel().getStat(this.statClass)).isEnabled();
    }
}

