/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.service.requirements;

import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.RankData;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.service.requirements.IndividualRequirement;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;

public class RankDifferenceRequirement
extends IndividualRequirement {
    private final TerritoryData territoryData;
    private final ITanPlayer tanPlayer;
    private final RankData rankToCompare;

    public RankDifferenceRequirement(TerritoryData territoryData, ITanPlayer tanPlayer, RankData rankToCompare) {
        this.territoryData = territoryData;
        this.tanPlayer = tanPlayer;
        this.rankToCompare = rankToCompare;
    }

    @Override
    public String getLine(LangType langType) {
        return this.isInvalid() ? Lang.REQUIREMENT_RANK_LEVEL_NEGATIVE.get(langType, this.territoryData.getRank(this.tanPlayer).getName(), this.rankToCompare.getName()) : Lang.REQUIREMENT_RANK_LEVEL_POSITIVE.get(langType, this.territoryData.getRank(this.tanPlayer).getName(), this.rankToCompare.getName());
    }

    @Override
    public boolean isInvalid() {
        if (this.territoryData.isLeader(this.tanPlayer)) {
            return false;
        }
        return this.territoryData.getRank(this.tanPlayer).getLevel() <= this.rankToCompare.getLevel();
    }
}

