/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.player;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.lib.data.SoundEnum;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.user.territory.NoTownMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.TownDataStorage;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class ApplyToTownMenu
extends IteratorGUI {
    public ApplyToTownMenu(Player player) {
        super(player, Lang.HEADER_TOWN_LIST, 6);
        this.open();
    }

    @Override
    public void open() {
        GuiUtil.createIterator(this.gui, this.getTowns(), this.page, this.player, p -> new NoTownMenu(this.player), p -> this.nextPage(), p -> this.previousPage());
        this.gui.open((HumanEntity)this.player);
    }

    public List<GuiItem> getTowns() {
        ArrayList<GuiItem> towns = new ArrayList<GuiItem>();
        for (TownData specificTownData : TownDataStorage.getInstance().getAll().values()) {
            towns.add(specificTownData.getIconWithInformations(this.tanPlayer.getLang()).addDescription(specificTownData.isRecruiting() ? Lang.GUI_TOWN_INFO_IS_RECRUITING.get() : Lang.GUI_TOWN_INFO_IS_NOT_RECRUITING.get()).setClickToAcceptMessage(specificTownData.isPlayerAlreadyRequested(this.player) ? Lang.GUI_TOWN_INFO_RIGHT_CLICK_TO_CANCEL : Lang.GUI_TOWN_INFO_LEFT_CLICK_TO_JOIN).setAction(action -> {
                if (action.isLeftClick()) {
                    if (!this.player.hasPermission("tan.base.town.join")) {
                        TanChatUtils.message(this.player, Lang.PLAYER_NO_PERMISSION.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
                        return;
                    }
                    if (specificTownData.isPlayerAlreadyRequested(this.player)) {
                        return;
                    }
                    if (!specificTownData.isRecruiting()) {
                        TanChatUtils.message(this.player, Lang.PLAYER_TOWN_NOT_RECRUITING.get(this.tanPlayer));
                        return;
                    }
                    specificTownData.addPlayerJoinRequest(this.player);
                    TanChatUtils.message(this.player, Lang.PLAYER_ASK_TO_JOIN_TOWN_PLAYER_SIDE.get(this.tanPlayer, specificTownData.getName()));
                    this.open();
                }
                if (action.isRightClick()) {
                    if (!specificTownData.isPlayerAlreadyRequested(this.player)) {
                        return;
                    }
                    specificTownData.removePlayerJoinRequest(this.player);
                    TanChatUtils.message(this.player, Lang.PLAYER_REMOVE_ASK_TO_JOIN_TOWN_PLAYER_SIDE.get(this.tanPlayer));
                    this.open();
                }
            }).asGuiItem(this.player, this.langType));
        }
        return towns;
    }
}

