/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.property;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.tan.enums.permissions.ChunkPermissionType;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.user.property.AddPlayerWithPermissionMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.PermissionManager;
import org.leralix.tan.utils.deprecated.HeadUtils;

public class BrowsePlayerWithPermissionMenu
extends IteratorGUI {
    private final PermissionManager permissionManager;
    private final ChunkPermissionType chunkPermission;
    private final BasicGui returnMenu;

    public BrowsePlayerWithPermissionMenu(Player player, PermissionManager permissionManager, ChunkPermissionType permission, BasicGui returnMenu) {
        super(player, permission.getLabel(), 3);
        this.permissionManager = permissionManager;
        this.chunkPermission = permission;
        this.returnMenu = returnMenu;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getAuthorizedPlayers(), p -> this.returnMenu.open());
        this.gui.setItem(3, 5, this.getAddPlayerButton());
        this.gui.open((HumanEntity)this.player);
    }

    private GuiItem getAddPlayerButton() {
        return this.iconManager.get(IconKey.ADD_PLAYER_ICON).setName(Lang.GUI_GENERIC_ADD_BUTTON.get(this.tanPlayer)).setAction(event -> {
            event.setCancelled(true);
            new AddPlayerWithPermissionMenu(this.player, this.permissionManager, this.chunkPermission, this);
        }).asGuiItem(this.player, this.langType);
    }

    private List<GuiItem> getAuthorizedPlayers() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (String authorizedPlayerID : this.permissionManager.get(this.chunkPermission).getAuthorizedPlayers()) {
            OfflinePlayer authorizedPlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(authorizedPlayerID));
            ItemStack icon = HeadUtils.getPlayerHead(authorizedPlayer.getName(), authorizedPlayer, Lang.GUI_TOWN_MEMBER_DESC3.get(this.tanPlayer));
            GuiItem guiItem = ItemBuilder.from(icon).asGuiItem(event -> {
                event.setCancelled(true);
                if (event.isRightClick()) {
                    this.permissionManager.get(this.chunkPermission).removeSpecificPlayerPermission(authorizedPlayerID);
                    this.open();
                }
            });
            guiItems.add(guiItem);
        }
        return guiItems;
    }
}

