/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.ranks;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.lib.data.SoundEnum;
import org.leralix.lib.utils.SoundUtil;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.dataclass.RankData;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.enums.RankEnum;
import org.leralix.tan.gui.BasicGui;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.user.ranks.AssignPlayerToRankMenu;
import org.leralix.tan.gui.user.ranks.ManageRankPermissionMenu;
import org.leralix.tan.gui.user.territory.TerritoryRanksMenu;
import org.leralix.tan.lang.FilledLang;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.listeners.chat.PlayerChatListenerStorage;
import org.leralix.tan.listeners.chat.events.RenameRank;
import org.leralix.tan.utils.deprecated.GuiUtil;
import org.leralix.tan.utils.text.TanChatUtils;

public class RankManagerMenu
extends BasicGui {
    private final TerritoryData territoryData;
    private final RankData rankData;

    public RankManagerMenu(Player player, TerritoryData territoryData, RankData rankData) {
        super(player, Lang.HEADER_TERRITORY_RANKS.get(rankData.getName()), 4);
        this.territoryData = territoryData;
        this.rankData = rankData;
        this.open();
    }

    @Override
    public void open() {
        this.fillTopLayer(this.rankData.getRankEnum().getRankColorGuiIcon());
        this.gui.setItem(1, 5, this.getRankIcon());
        this.gui.setItem(2, 2, this.getRankLevel());
        this.gui.setItem(2, 3, this.getAddPlayerButton());
        this.gui.setItem(2, 4, this.getManagePermissionIcon());
        this.gui.setItem(2, 6, this.lowerSalaryButton());
        this.gui.setItem(2, 7, this.getSalaryIcon());
        this.gui.setItem(2, 8, this.increaseSalaryButton());
        this.gui.setItem(3, 2, this.getRenameRankButton());
        this.gui.setItem(3, 3, this.getPayTaxRankButton());
        this.gui.setItem(3, 4, this.getDefaultRankButton());
        this.gui.setItem(3, 6, this.deleteRankIcon());
        this.gui.setItem(4, 1, GuiUtil.createBackArrow(this.player, p -> new TerritoryRanksMenu(this.player, this.territoryData).open()));
        this.gui.open((HumanEntity)this.player);
    }

    private void fillTopLayer(GuiItem rankColorGuiIcon) {
        for (int i = 0; i <= 8; ++i) {
            this.gui.setItem(i, rankColorGuiIcon);
        }
    }

    private GuiItem deleteRankIcon() {
        boolean isEmpty = this.rankData.getPlayersID().isEmpty();
        boolean isDefaultRank = Objects.equals(this.rankData.getID(), this.territoryData.getDefaultRankID());
        return this.iconManager.get(IconKey.DELETE_RANK_ICON).setName(Lang.GUI_TOWN_MEMBERS_ROLE_DELETE.get(this.tanPlayer)).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_PROCEED).setAction(event -> {
            if (!isEmpty) {
                TanChatUtils.message(this.player, Lang.GUI_TOWN_MEMBERS_ROLE_DELETE_ERROR_NOT_EMPTY.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
                return;
            }
            if (isDefaultRank) {
                TanChatUtils.message(this.player, Lang.GUI_TOWN_MEMBERS_ROLE_DELETE_ERROR_DEFAULT.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
                return;
            }
            this.territoryData.removeRank(this.rankData.getID());
            new TerritoryRanksMenu(this.player, this.territoryData).open();
            SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.MINOR_GOOD);
        }).asGuiItem(this.player, this.langType);
    }

    private GuiItem getDefaultRankButton() {
        boolean isDefaultRank = Objects.equals(this.rankData.getID(), this.territoryData.getDefaultRankID());
        ArrayList<FilledLang> description = new ArrayList<FilledLang>();
        description.add(isDefaultRank ? Lang.GUI_TOWN_MEMBERS_ROLE_SET_DEFAULT_IS_DEFAULT.get() : Lang.GUI_TOWN_MEMBERS_ROLE_SET_DEFAULT_IS_NOT_DEFAULT.get());
        description.add(Lang.GUI_TOWN_MEMBERS_ROLE_SET_DEFAULT1.get());
        return this.iconManager.get(IconKey.SET_DEFAULT_ROLE_ICON).setName(Lang.GUI_TOWN_MEMBERS_ROLE_SET_DEFAULT.get(this.langType, new String[0])).setDescription(description).setClickToAcceptMessage(Lang.GUI_TOWN_MEMBERS_ROLE_SET_DEFAULT2).setAction(event -> {
            if (isDefaultRank) {
                TanChatUtils.message(this.player, Lang.GUI_TOWN_MEMBERS_ROLE_SET_DEFAULT_ALREADY_DEFAULT.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
            } else {
                this.territoryData.setDefaultRank(this.rankData.getID());
                this.open();
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.ADD);
            }
        }).asGuiItem(this.player, this.langType);
    }

    private GuiItem getPayTaxRankButton() {
        return this.iconManager.get(IconKey.PAY_TAXES_ICON).setName(Lang.GUI_TOWN_MEMBERS_ROLE_PAY_TAXES_NAME.get(this.tanPlayer)).setDescription(this.rankData.isPayingTaxes() ? Lang.GUI_TOWN_MEMBERS_ROLE_PAY_TAXES.get() : Lang.GUI_TOWN_MEMBERS_ROLE_NOT_PAY_TAXES.get()).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_MODIFY).setAction(event -> {
            this.rankData.swapPayingTaxes();
            SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.ADD);
            this.open();
        }).asGuiItem(this.player, this.langType);
    }

    private GuiItem getRenameRankButton() {
        return this.iconManager.get(IconKey.RENAME_RANK_ICON).setName(Lang.GUI_TOWN_MEMBERS_ROLE_CHANGE_NAME.get(this.tanPlayer)).setClickToAcceptMessage(Lang.GUI_GENERIC_CLICK_TO_PROCEED).setAction(event -> {
            TanChatUtils.message(this.player, Lang.WRITE_IN_CHAT_NEW_ROLE_NAME.get(this.tanPlayer));
            PlayerChatListenerStorage.register(this.player, new RenameRank(this.territoryData, this.rankData));
        }).asGuiItem(this.player, this.langType);
    }

    private GuiItem increaseSalaryButton() {
        return this.iconManager.get(IconKey.INCREASE_SALARY_ICON).setName(Lang.GUI_LOWER_SALARY.get(this.tanPlayer)).setDescription(Lang.GUI_INCREASE_1_DESC.get(), Lang.GUI_INCREASE_10_DESC.get()).setAction(event -> {
            int amountToAdd = event.isShiftClick() ? 10 : 1;
            this.rankData.addFromSalary(amountToAdd);
            SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.ADD);
            this.open();
        }).asGuiItem(this.player, this.langType);
    }

    private GuiItem getSalaryIcon() {
        return this.iconManager.get(IconKey.CURRENT_SALARY_ICON).setName(Lang.GUI_TOWN_MEMBERS_ROLE_SALARY.get(this.tanPlayer)).setDescription(Lang.GUI_TOWN_MEMBERS_ROLE_SALARY_DESC1.get(Integer.toString(this.rankData.getSalary()))).asGuiItem(this.player, this.langType);
    }

    private GuiItem lowerSalaryButton() {
        return this.iconManager.get(IconKey.DECREASE_SALARY_ICON).setName(Lang.GUI_LOWER_SALARY.get(this.tanPlayer)).setDescription(Lang.GUI_DECREASE_1_DESC.get(), Lang.GUI_DECREASE_10_DESC.get()).setAction(event -> {
            int amountToRemove;
            int currentSalary = this.rankData.getSalary();
            int n = amountToRemove = event.isShiftClick() && currentSalary >= 10 ? 10 : 1;
            if (currentSalary <= 0) {
                TanChatUtils.message(this.player, Lang.GUI_TOWN_MEMBERS_ROLE_SALARY_ERROR_LOWER.get(this.tanPlayer), SoundEnum.NOT_ALLOWED);
                return;
            }
            this.rankData.removeFromSalary(amountToRemove);
            SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.REMOVE);
            this.open();
        }).asGuiItem(this.player, this.langType);
    }

    private GuiItem getManagePermissionIcon() {
        return this.iconManager.get(IconKey.MANAGE_PERMISSION_ICON).setName(Lang.GUI_TOWN_MEMBERS_ROLE_MANAGE_PERMISSION.get(this.tanPlayer)).setAction(event -> new ManageRankPermissionMenu(this.player, this.territoryData, this.rankData)).asGuiItem(this.player, this.langType);
    }

    private GuiItem getRankLevel() {
        RankEnum rankEnum = this.rankData.getRankEnum();
        return this.iconManager.get(this.rankData.getRankEnum().getBasicRankIcon()).setName(String.valueOf(rankEnum.getColor()) + Lang.GUI_TOWN_MEMBERS_ROLE_PRIORITY_X.get(this.tanPlayer, Integer.toString(rankEnum.getLevel()))).setClickToAcceptMessage(Lang.GUI_TOWN_MEMBERS_ROLE_PRIORITY_DESC1, Lang.GUI_TOWN_MEMBERS_ROLE_PRIORITY_DESC2).setAction(event -> {
            boolean isInferiorOrEquals;
            RankData playerRank = this.territoryData.getRank(this.player);
            boolean isLeader = this.territoryData.isLeader(this.player);
            boolean bl = isInferiorOrEquals = playerRank.getRankEnum().getLevel() <= this.rankData.getRankEnum().getLevel() + 1;
            if (isInferiorOrEquals && !isLeader) {
                TanChatUtils.message(this.player, Lang.GUI_TOWN_MEMBERS_ROLE_RANK_UP_INFERIOR_RANK.get(this.tanPlayer, playerRank.getColoredName()));
                return;
            }
            if (event.isLeftClick()) {
                this.rankData.incrementLevel();
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.ADD);
            } else if (event.isRightClick()) {
                this.rankData.decrementLevel();
                SoundUtil.playSound((Player)this.player, (SoundEnum)SoundEnum.REMOVE);
            }
            this.open();
        }).asGuiItem(this.player, this.langType);
    }

    private GuiItem getRankIcon() {
        return this.iconManager.get(this.rankData.getRankIcon()).setName(Lang.GUI_BASIC_NAME.get(this.tanPlayer, this.rankData.getColoredName())).setClickToAcceptMessage(Lang.GUI_TOWN_MEMBERS_ROLE_NAME_DESC1).setAction(event -> {
            ItemStack itemMaterial = event.getCursor();
            if (itemMaterial.getType() == Material.AIR) {
                TanChatUtils.message(this.player, Lang.GUI_TOWN_MEMBERS_ROLE_NO_ITEM_SHOWED.get(this.tanPlayer));
                return;
            }
            this.rankData.setRankIcon(itemMaterial);
            this.open();
            TanChatUtils.message(this.player, Lang.GUI_TOWN_MEMBERS_ROLE_CHANGED_ICON_SUCCESS.get(this.tanPlayer));
        }).asGuiItem(this.player, this.langType);
    }

    private GuiItem getAddPlayerButton() {
        ArrayList<FilledLang> description = new ArrayList<FilledLang>();
        for (ITanPlayer tanPlayer : this.rankData.getPlayers()) {
            description.add(Lang.GUI_TOWN_MEMBERS_ROLE_MEMBER_LIST_INFO_DESC.get(tanPlayer.getNameStored()));
        }
        return this.iconManager.get(IconKey.PLAYER_LIST_ICON).setName(Lang.GUI_TOWN_MEMBERS_ROLE_MEMBER_LIST_INFO.get(this.tanPlayer)).setDescription(description).setClickToAcceptMessage(Lang.GUI_TOWN_MEMBERS_ROLE_MEMBER_LIST_INFO_DESC1).setAction(p -> new AssignPlayerToRankMenu(this.player, this.territoryData, this.rankData).open()).asGuiItem(this.player, this.langType);
    }
}

