/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.builder.item.ItemBuilder;
import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.common.ConfirmMenu;
import org.leralix.tan.gui.legacy.PlayerGUI;
import org.leralix.tan.gui.user.territory.TownSettingsMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.utils.deprecated.HeadUtils;
import org.leralix.tan.utils.text.TanChatUtils;

public class SelectNewOwnerForTownMenu
extends IteratorGUI {
    private final TownData townData;

    public SelectNewOwnerForTownMenu(Player player, TownData townData) {
        super(player, Lang.HEADER_CHANGE_OWNERSHIP, 3);
        this.townData = townData;
        this.open();
    }

    @Override
    public void open() {
        this.iterator(this.getCandidates(), p -> new TownSettingsMenu(this.player, this.townData));
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getCandidates() {
        ArrayList<GuiItem> guiItems = new ArrayList<GuiItem>();
        for (String playerUUID : this.townData.getPlayerIDList()) {
            OfflinePlayer townPlayer = Bukkit.getServer().getOfflinePlayer(UUID.fromString(playerUUID));
            ItemStack playerHead = HeadUtils.getPlayerHead(townPlayer.getName(), townPlayer, Lang.GUI_TOWN_SETTINGS_TRANSFER_OWNERSHIP_TO_SPECIFIC_PLAYER_DESC1.get(this.tanPlayer, this.player.getName()), Lang.GUI_TOWN_SETTINGS_TRANSFER_OWNERSHIP_TO_SPECIFIC_PLAYER_DESC2.get(this.tanPlayer));
            GuiItem playerHeadIcon = ItemBuilder.from(playerHead).asGuiItem(event -> {
                event.setCancelled(true);
                new ConfirmMenu(this.player, Lang.GUI_CONFIRM_CHANGE_TOWN_LEADER.get(townPlayer.getName()), () -> {
                    this.townData.setLeaderID(townPlayer.getUniqueId().toString());
                    TanChatUtils.message(this.player, Lang.GUI_TOWN_SETTINGS_TRANSFER_OWNERSHIP_TO_SPECIFIC_PLAYER_SUCCESS.get(this.tanPlayer, townPlayer.getName()));
                    PlayerGUI.dispatchPlayerTown(this.player);
                    this.player.closeInventory();
                }, this::open);
            });
            guiItems.add(playerHeadIcon);
        }
        return guiItems;
    }
}

