/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.List;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.enums.RolePermission;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.gui.service.requirements.RankPermissionRequirement;
import org.leralix.tan.gui.user.territory.PlayerApplicationMenu;
import org.leralix.tan.gui.user.territory.TerritoryRanksMenu;
import org.leralix.tan.lang.Lang;

public class TerritoryMemberMenu
extends IteratorGUI {
    private final TerritoryData territoryData;

    public TerritoryMemberMenu(Player player, TerritoryData territoryData) {
        super(player, Lang.HEADER_TOWN_MEMBERS, 6);
        this.territoryData = territoryData;
    }

    @Override
    public void open() {
        this.iterator(this.getMemberList(), p -> this.territoryData.openMainMenu(this.player));
        this.gui.setItem(6, 4, this.getManageRankButton());
        TerritoryData territoryData = this.territoryData;
        if (territoryData instanceof TownData) {
            TownData townData = (TownData)territoryData;
            this.gui.setItem(6, 5, this.getManageApplicationsButton(townData));
        }
        this.gui.open((HumanEntity)this.player);
    }

    private List<GuiItem> getMemberList() {
        return this.territoryData.getOrderedMemberList(this.tanPlayer);
    }

    private GuiItem getManageRankButton() {
        return IconManager.getInstance().get(IconKey.MANAGE_RANKS_ICON).setName(Lang.GUI_TOWN_MEMBERS_MANAGE_ROLES.get(this.tanPlayer)).setRequirements(new RankPermissionRequirement(this.territoryData, this.tanPlayer, RolePermission.MANAGE_RANKS)).setAction(p -> new TerritoryRanksMenu(this.player, this.territoryData).open()).asGuiItem(this.player, this.langType);
    }

    private GuiItem getManageApplicationsButton(TownData townData) {
        return IconManager.getInstance().get(IconKey.MANAGE_APPLICATIONS_ICON).setName(Lang.GUI_TOWN_MEMBERS_MANAGE_APPLICATION.get(this.tanPlayer)).setRequirements(new RankPermissionRequirement(this.territoryData, this.tanPlayer, RolePermission.INVITE_PLAYER)).setDescription(Lang.GUI_TOWN_MEMBERS_MANAGE_APPLICATION_DESC1.get(Integer.toString(townData.getPlayerJoinRequestSet().size()))).setAction(p -> new PlayerApplicationMenu(this.player, townData).open()).asGuiItem(this.player, this.langType);
    }
}

