/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory;

import dev.triumphteam.gui.guis.GuiItem;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.territory.TownData;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.gui.user.MainMenu;
import org.leralix.tan.gui.user.territory.PlayerOwnedLandmarksMenu;
import org.leralix.tan.gui.user.territory.TerritoryMenu;
import org.leralix.tan.gui.user.territory.TownSettingsMenu;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.stored.PlayerDataStorage;
import org.leralix.tan.utils.deprecated.GuiUtil;

public class TownMenu
extends TerritoryMenu {
    private final TownData townData;

    public TownMenu(Player player, TownData townData) {
        super(player, Lang.HEADER_TOWN_MENU.get(PlayerDataStorage.getInstance().get(player).getTown().getName()), townData);
        this.townData = townData;
        this.open();
    }

    @Override
    public void open() {
        this.gui.setItem(1, 5, this.getTerritoryInfo());
        this.gui.getFiller().fillTop(GuiUtil.getUnnamedItem(Material.BLUE_STAINED_GLASS_PANE));
        this.gui.setItem(2, 2, this.getTownTreasuryButton());
        this.gui.setItem(2, 3, this.getMemberButton());
        this.gui.setItem(2, 4, this.getLandButton());
        this.gui.setItem(2, 5, this.getBrowseButton());
        this.gui.setItem(2, 6, this.getDiplomacyButton());
        this.gui.setItem(2, 7, this.getLevelButton());
        this.gui.setItem(2, 8, this.getSettingsButton());
        this.gui.setItem(3, 2, this.getBuildingButton());
        this.gui.setItem(3, 3, this.getAttackButton());
        this.gui.setItem(3, 4, this.getHierarchyButton());
        this.gui.setItem(3, 8, this.getLandmarksButton());
        this.gui.setItem(4, 1, GuiUtil.createBackArrow(this.player, MainMenu::new));
        this.gui.open((HumanEntity)this.player);
    }

    private GuiItem getSettingsButton() {
        return IconManager.getInstance().get(IconKey.TERRITORY_SETTINGS_ICON).setName(Lang.GUI_TOWN_SETTINGS_ICON.get(this.tanPlayer.getLang(), new String[0])).setDescription(Lang.GUI_TOWN_SETTINGS_ICON_DESC1.get()).setAction(event -> new TownSettingsMenu(this.player, this.townData)).asGuiItem(this.player, this.langType);
    }

    private GuiItem getLandmarksButton() {
        return IconManager.getInstance().get(IconKey.TOWN_LANDMARKS_ICON).setName(Lang.ADMIN_GUI_LANDMARK_ICON.get(this.tanPlayer.getLang(), new String[0])).setDescription(Lang.ADMIN_GUI_LANDMARK_DESC1.get()).setAction(event -> new PlayerOwnedLandmarksMenu(this.player, this.townData)).asGuiItem(this.player, this.langType);
    }
}

