/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.gui.user.territory.history;

import dev.triumphteam.gui.guis.GuiItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.gui.IteratorGUI;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.storage.database.transactions.AbstractTransaction;
import org.leralix.tan.storage.database.transactions.EntityScope;
import org.leralix.tan.storage.database.transactions.TransactionManager;
import org.leralix.tan.storage.database.transactions.TransactionType;
import org.leralix.tan.utils.deprecated.GuiUtil;

public abstract class AbstractTransactionHistory
extends IteratorGUI {
    private TransactionType transactionType;
    private final Consumer<Player> guiCallback;

    protected AbstractTransactionHistory(Player player, Consumer<Player> guiCallback) {
        this(player, guiCallback, TransactionType.INDEX);
    }

    protected AbstractTransactionHistory(Player player, Consumer<Player> guiCallback, TransactionType transactionType) {
        super(player, Lang.HEADER_HISTORY, 6);
        this.guiCallback = guiCallback;
        this.transactionType = transactionType;
    }

    @Override
    public void open() {
        this.iterator(this.getTransactions(), this.guiCallback);
        this.gui.setItem(6, 5, this.getNextScopeButton());
        this.gui.open((HumanEntity)this.player);
    }

    @NotNull
    private GuiItem getNextScopeButton() {
        return GuiUtil.getNextScopeButton(this.iconManager, this, this.transactionType, newValue -> {
            this.transactionType = newValue;
        }, this.langType, this.player);
    }

    protected abstract EntityScope getScope();

    private List<GuiItem> getTransactions() {
        ArrayList<GuiItem> res = new ArrayList<GuiItem>();
        List<AbstractTransaction> transactions = TransactionManager.getInstance().getTransactionOf(this.getID(), this.transactionType);
        for (AbstractTransaction transaction : transactions) {
            res.add(transaction.getIcon(this.iconManager, this.player, this.langType));
        }
        return res;
    }

    protected abstract String getID();
}

