/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.lang;

import java.util.Collections;
import java.util.List;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.ITanPlayer;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.stored.PlayerDataStorage;

public class FilledLang {
    private final Lang lang;
    private final List<String> placeholders;

    public FilledLang(Lang lang) {
        this.lang = lang;
        this.placeholders = Collections.emptyList();
    }

    public FilledLang(Lang lang, String ... placeholders) {
        this.lang = lang;
        this.placeholders = List.of(placeholders);
    }

    public String getDefault() {
        return this.lang.get(Lang.getServerLang(), this.placeholders);
    }

    public String get(LangType langType) {
        return this.lang.get(langType, this.placeholders);
    }

    public String get(ITanPlayer player) {
        return this.get(player.getLang());
    }

    public String get(Player player) {
        return this.lang.get(PlayerDataStorage.getInstance().get(player).getLang(), this.placeholders);
    }
}

