/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.database.transactions;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.jetbrains.annotations.NotNull;
import org.leralix.tan.TownsAndNations;
import org.leralix.tan.storage.database.transactions.AbstractTransaction;
import org.leralix.tan.storage.database.transactions.TransactionType;
import org.leralix.tan.storage.database.transactions.instance.CreatingPropertyTransaction;
import org.leralix.tan.storage.database.transactions.instance.DonationTransaction;
import org.leralix.tan.storage.database.transactions.instance.PaymentTransaction;
import org.leralix.tan.storage.database.transactions.instance.PlayerTaxTransaction;
import org.leralix.tan.storage.database.transactions.instance.RentingPropertyTransaction;
import org.leralix.tan.storage.database.transactions.instance.RetrieveTransaction;
import org.leralix.tan.storage.database.transactions.instance.SalaryTransaction;
import org.leralix.tan.storage.database.transactions.instance.SellingPropertyTransaction;
import org.leralix.tan.storage.database.transactions.instance.TerritoryTaxTransaction;
import org.leralix.tan.storage.database.transactions.instance.UpgradeTransaction;

public class TransactionManager {
    private final DataSource dataSource;
    private static TransactionManager instance;
    private final Logger pluginLogger;
    private final String SQL_INDEX_STATEMENT = "INSERT INTO transaction_index (concerned, id_transaction, type) VALUES (?, ?, ?)";

    private TransactionManager(DataSource dataSource) {
        this.dataSource = dataSource;
        this.pluginLogger = TownsAndNations.getPlugin().getLogger();
        this.registerDatabases();
    }

    public static TransactionManager getInstance() {
        if (instance == null) {
            instance = new TransactionManager(TownsAndNations.getPlugin().getDatabaseHandler().getDataSource());
        }
        return instance;
    }

    private void registerDatabases() {
        try (Connection conn = this.dataSource.getConnection();
             Statement statement = conn.createStatement();){
            String dbName = conn.getMetaData().getDatabaseProductName().toLowerCase();
            String autoIncrementSyntax = dbName.contains("sqlite") ? "INTEGER PRIMARY KEY AUTOINCREMENT" : (dbName.contains("mysql") ? "BIGINT AUTO_INCREMENT PRIMARY KEY" : "BIGSERIAL PRIMARY KEY");
            for (TransactionType transactionType : TransactionType.values()) {
                statement.addBatch(transactionType.getCreateTableSQL(autoIncrementSyntax));
            }
            statement.executeBatch();
            this.pluginLogger.info("[TAN] All transaction tables created or verified successfully for DB: " + dbName);
        }
        catch (SQLException e) {
            this.pluginLogger.severe("Error while creating transaction tables: " + e.getMessage());
        }
    }

    public List<AbstractTransaction> getTransactionOf(String concernedID, TransactionType transactionType) {
        List<AbstractTransaction> list;
        block8: {
            Connection conn = this.dataSource.getConnection();
            try {
                list = this.getTransactionOf(conn, concernedID, transactionType);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.pluginLogger.severe("[TAN] Error while connecting to the database: " + e.getMessage());
                    return Collections.emptyList();
                }
            }
            conn.close();
        }
        return list;
    }

    private List<AbstractTransaction> getTransactionOf(Connection conn, String concernedID, TransactionType wantedType) {
        EnumMap<TransactionType, List<Long>> transactionIdsByType;
        block18: {
            String sqlIndex = "SELECT id_transaction, type\nFROM transaction_index\nWHERE concerned = ?\nORDER BY id_transaction DESC\n";
            transactionIdsByType = new EnumMap<TransactionType, List<Long>>(TransactionType.class);
            try (PreparedStatement ps = conn.prepareStatement(sqlIndex);){
                ps.setString(1, concernedID);
                ResultSet rs = ps.executeQuery();
                block14: while (true) {
                    while (rs.next()) {
                        long transactionId = rs.getLong("id_transaction");
                        String typeStr = rs.getString("type");
                        try {
                            TransactionType transactionType = TransactionType.valueOf(typeStr);
                            if (wantedType != TransactionType.INDEX && transactionType != wantedType) continue;
                            transactionIdsByType.computeIfAbsent(transactionType, k -> new ArrayList()).add(transactionId);
                            continue block14;
                        }
                        catch (IllegalArgumentException ignored) {
                            this.pluginLogger.warning("[TAN] Unknown transaction type in DB: " + typeStr);
                        }
                    }
                    break block18;
                    {
                        continue block14;
                        break;
                    }
                    break;
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            catch (SQLException e) {
                this.pluginLogger.severe("[TAN] Error while reading index: " + e.getMessage());
                return Collections.emptyList();
            }
        }
        return this.getTransactionById(conn, transactionIdsByType);
    }

    @NotNull
    private List<AbstractTransaction> getTransactionById(Connection conn, EnumMap<TransactionType, List<Long>> transactionIdsByType) {
        ArrayList<AbstractTransaction> transactions = new ArrayList<AbstractTransaction>();
        for (Map.Entry<TransactionType, List<Long>> entry : transactionIdsByType.entrySet()) {
            Class wantedClass;
            TransactionType type = entry.getKey();
            List<Long> ids = entry.getValue();
            switch (type) {
                case PAYMENT: {
                    Class clazz = PaymentTransaction.class;
                    break;
                }
                case DONATION: {
                    Class clazz = DonationTransaction.class;
                    break;
                }
                case RETRIEVE: {
                    Class clazz = RetrieveTransaction.class;
                    break;
                }
                case TAXES: {
                    Class clazz = PlayerTaxTransaction.class;
                    break;
                }
                case TERRITORY_TAX: {
                    Class clazz = TerritoryTaxTransaction.class;
                    break;
                }
                case SALARY: {
                    Class clazz = SalaryTransaction.class;
                    break;
                }
                case UPGRADE: {
                    Class clazz = UpgradeTransaction.class;
                    break;
                }
                case CREATE_PROPERTY: {
                    Class clazz = CreatingPropertyTransaction.class;
                    break;
                }
                case SELLING_PROPERTY: {
                    Class clazz = SellingPropertyTransaction.class;
                    break;
                }
                case RENTING_PROPERTY: {
                    Class clazz = RentingPropertyTransaction.class;
                    break;
                }
                default: {
                    Class clazz = wantedClass = null;
                }
            }
            if (wantedClass == null) {
                this.pluginLogger.warning("[TAN] Unhandled transaction type: " + String.valueOf(type));
                continue;
            }
            transactions.addAll(this.getTransactionsGeneric(conn, ids, type, wantedClass));
        }
        return transactions;
    }

    private <T extends AbstractTransaction> List<T> getTransactionsGeneric(Connection conn, List<Long> ids, TransactionType transactionType, Class<T> clazz) {
        if (ids == null || ids.isEmpty()) {
            return Collections.emptyList();
        }
        String placeholders = String.join((CharSequence)",", Collections.nCopies(ids.size(), "?"));
        String sql = "SELECT * FROM " + transactionType.getTableName() + " WHERE id IN (" + placeholders + ")";
        ArrayList<T> results = new ArrayList<T>();
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            for (int i = 0; i < ids.size(); ++i) {
                ps.setLong(i + 1, ids.get(i));
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    results.add(AbstractTransaction.fromResultSet(rs, clazz));
                }
            }
        }
        catch (SQLException e) {
            this.pluginLogger.severe("[TAN] Error while fetching on " + transactionType.getTableName() + ": " + e.getMessage());
        }
        return results;
    }

    public void register(AbstractTransaction transaction) {
        try (Connection conn = this.dataSource.getConnection();){
            this.insertTransaction(conn, transaction);
        }
        catch (SQLException e) {
            this.pluginLogger.severe("[TAN] Error while inserting transaction: " + e.getMessage());
        }
    }

    private void insertTransaction(Connection conn, AbstractTransaction transaction) throws SQLException {
        long transactionID;
        block13: {
            try (PreparedStatement ps = conn.prepareStatement(transaction.getInsertSQL(), 1);){
                transaction.fillInsertStatement(ps);
                ps.executeUpdate();
                try (ResultSet rs = ps.getGeneratedKeys();){
                    if (rs.next()) {
                        transactionID = rs.getLong(1);
                        break block13;
                    }
                    throw new SQLException("Failed to retrieve generated transaction ID for " + String.valueOf(transaction.getType()));
                }
            }
        }
        this.addToIndex(conn, transactionID, transaction.getType(), transaction.getConcerned());
    }

    private void addToIndex(Connection conn, long transactionId, TransactionType transactionType, Set<String> concerned) throws SQLException {
        if (concerned == null || concerned.isEmpty()) {
            return;
        }
        try (PreparedStatement ps = conn.prepareStatement("INSERT INTO transaction_index (concerned, id_transaction, type) VALUES (?, ?, ?)");){
            for (String c : concerned) {
                ps.setString(1, c);
                ps.setLong(2, transactionId);
                ps.setString(3, transactionType.name());
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }
}

