/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.database.transactions.instance;

import dev.triumphteam.gui.guis.GuiItem;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Player;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.database.transactions.AbstractTransaction;
import org.leralix.tan.storage.database.transactions.TransactionType;

public class CreatingPropertyTransaction
extends AbstractTransaction {
    private final String territoryID;
    private final String propertyID;
    private final String creatorID;
    private final double amount;
    private final double taxPerBlock;

    public CreatingPropertyTransaction(String territoryID, String propertyID, String creatorID, double amount, double taxPerBlock) {
        this.territoryID = territoryID;
        this.propertyID = propertyID;
        this.creatorID = creatorID;
        this.amount = amount;
        this.taxPerBlock = taxPerBlock;
    }

    public CreatingPropertyTransaction(ResultSet rs) throws SQLException {
        long timestamp = rs.getLong("timestamp");
        this.localDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        this.territoryID = rs.getString("territory_id");
        this.propertyID = rs.getString("property_id");
        this.creatorID = rs.getString("creator_id");
        this.amount = rs.getDouble("amount");
        this.taxPerBlock = rs.getInt("tax_per_block");
    }

    @Override
    public TransactionType getType() {
        return TransactionType.CREATE_PROPERTY;
    }

    @Override
    public GuiItem getIcon(IconManager iconManager, Player player, LangType langType) {
        return iconManager.get(IconKey.PROPERTY_CREATE_TRANSACTION).setName(Lang.SELL_PROPERTY_TRANSACTION.get(langType, new String[0])).setDescription(Lang.TRANSACTION_FROM.get(this.getColoredName(this.creatorID, langType)), Lang.TRANSACTION_TO.get(this.getTerritoryName(this.territoryID, langType)), Lang.TRANSACTION_PROPERTY.get(this.getPropertyName(this.territoryID, this.propertyID, langType)), Lang.TRANSACTION_AMOUNT.get(Double.toString(this.amount)), Lang.TRANSACTION_FLAT_TAX.get(Double.toString(this.taxPerBlock))).asGuiItem(player, langType);
    }

    @Override
    public String getInsertSQL() {
        return "INSERT INTO transaction_create_property (timestamp, territory_id, property_id, creator_id, amount, tax_per_block) VALUES (?, ?, ?, ?, ?, ?)";
    }

    @Override
    public void fillInsertStatement(PreparedStatement ps) throws SQLException {
        ps.setLong(1, this.getDate().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        ps.setString(2, this.territoryID);
        ps.setString(3, this.propertyID);
        ps.setString(4, this.creatorID);
        ps.setDouble(5, this.amount);
        ps.setDouble(6, this.taxPerBlock);
    }

    @Override
    public Set<String> getConcerned() {
        HashSet<String> res = new HashSet<String>();
        res.add(this.territoryID);
        res.add(this.creatorID);
        return res;
    }
}

