/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.database.transactions.instance;

import dev.triumphteam.gui.guis.GuiItem;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Player;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.database.transactions.AbstractTransaction;
import org.leralix.tan.storage.database.transactions.TransactionType;

public class DonationTransaction
extends AbstractTransaction {
    private final String playerID;
    private final String territoryID;
    private final double amount;

    public DonationTransaction(TerritoryData territoryData, Player player, double amount) {
        this.playerID = player.getUniqueId().toString();
        this.territoryID = territoryData.getID();
        this.amount = amount;
    }

    public DonationTransaction(ResultSet rs) throws SQLException {
        long timestamp = rs.getLong("timestamp");
        this.localDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        this.territoryID = rs.getString("territory_id");
        this.playerID = rs.getString("player_id");
        this.amount = rs.getDouble("amount");
    }

    @Override
    public TransactionType getType() {
        return TransactionType.DONATION;
    }

    @Override
    public GuiItem getIcon(IconManager iconManager, Player player, LangType langType) {
        return iconManager.get(IconKey.DONATION_TRANSACTION).setName(Lang.DONATION_TRANSACTION_NAME.get(langType, new String[0])).setDescription(Lang.TRANSACTION_FROM.get(this.getPlayerName(this.playerID, langType)), Lang.TRANSACTION_TO.get(this.getTerritoryName(this.territoryID, langType)), Lang.TRANSACTION_AMOUNT.get(Double.toString(this.amount))).asGuiItem(player, langType);
    }

    @Override
    public String getInsertSQL() {
        return "INSERT INTO transaction_donation (timestamp, territory_id, player_id, amount) VALUES (?, ?, ?, ?)";
    }

    @Override
    public void fillInsertStatement(PreparedStatement ps) throws SQLException {
        ps.setLong(1, this.getDate().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        ps.setString(2, this.territoryID);
        ps.setString(3, this.playerID);
        ps.setDouble(4, this.amount);
    }

    @Override
    public Set<String> getConcerned() {
        HashSet<String> res = new HashSet<String>();
        res.add(this.territoryID);
        res.add(this.playerID);
        return res;
    }

    public String getPlayerID() {
        return this.playerID;
    }

    public String getTerritoryID() {
        return this.territoryID;
    }

    public double getAmount() {
        return this.amount;
    }
}

