/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.database.transactions.instance;

import dev.triumphteam.gui.guis.GuiItem;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Player;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.database.transactions.AbstractTransaction;
import org.leralix.tan.storage.database.transactions.TransactionType;

public class RentingPropertyTransaction
extends AbstractTransaction {
    private final String territoryID;
    private final String propertyID;
    private final String sellerID;
    private final String buyerID;
    private final double amount;
    private final double taxPercentage;

    public RentingPropertyTransaction(String territoryID, String propertyID, String sellerID, String buyerID, double amount, double taxPercentage) {
        this.territoryID = territoryID;
        this.propertyID = propertyID;
        this.sellerID = sellerID;
        this.buyerID = buyerID;
        this.amount = amount;
        this.taxPercentage = taxPercentage;
    }

    public RentingPropertyTransaction(ResultSet rs) throws SQLException {
        long timestamp = rs.getLong("timestamp");
        this.localDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        this.territoryID = rs.getString("territory_id");
        this.propertyID = rs.getString("property_id");
        this.sellerID = rs.getString("owner_id");
        this.buyerID = rs.getString("renter_id");
        this.amount = rs.getDouble("amount");
        this.taxPercentage = rs.getInt("tax_percentage");
    }

    @Override
    public TransactionType getType() {
        return TransactionType.RENTING_PROPERTY;
    }

    @Override
    public GuiItem getIcon(IconManager iconManager, Player player, LangType langType) {
        double taxedPart = this.amount * this.taxPercentage;
        return iconManager.get(IconKey.PROPERTY_RENT_TRANSACTION).setName(Lang.RENT_PROPERTY_TRANSACTION.get(langType, new String[0])).setDescription(Lang.TRANSACTION_FROM.get(this.getPlayerName(this.buyerID, langType)), Lang.TRANSACTION_TO.get(this.getColoredName(this.sellerID, langType)), Lang.TRANSACTION_PROPERTY.get(this.getPropertyName(this.territoryID, this.propertyID, langType)), Lang.TRANSACTION_AMOUNT.get(Double.toString(this.amount)), Lang.TRANSACTION_TAX.get(Double.toString(this.taxPercentage), Double.toString(taxedPart))).asGuiItem(player, langType);
    }

    @Override
    public String getInsertSQL() {
        return "INSERT INTO transaction_renting_property (timestamp, territory_id, property_id, seller_id, buyer_id, tax_percentage, amount) VALUES (?, ?, ?, ?, ?, ?, ?)";
    }

    @Override
    public void fillInsertStatement(PreparedStatement ps) throws SQLException {
        ps.setLong(1, this.getDate().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        ps.setString(2, this.territoryID);
        ps.setString(3, this.propertyID);
        ps.setString(4, this.sellerID);
        ps.setString(5, this.buyerID);
        ps.setDouble(6, this.taxPercentage);
        ps.setDouble(7, this.amount);
    }

    @Override
    public Set<String> getConcerned() {
        HashSet<String> res = new HashSet<String>();
        res.add(this.territoryID);
        res.add(this.sellerID);
        res.add(this.buyerID);
        return res;
    }
}

