/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.database.transactions.instance;

import dev.triumphteam.gui.guis.GuiItem;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Player;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.database.transactions.AbstractTransaction;
import org.leralix.tan.storage.database.transactions.TransactionType;

public class SalaryTransaction
extends AbstractTransaction {
    private final String territoryID;
    private final String playerID;
    private final double amount;

    public SalaryTransaction(String territoryID, String playerID, double amount) {
        this.territoryID = territoryID;
        this.playerID = playerID;
        this.amount = amount;
    }

    public SalaryTransaction(ResultSet rs) throws SQLException {
        long timestamp = rs.getLong("timestamp");
        this.localDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        this.playerID = rs.getString("player_id");
        this.territoryID = rs.getString("territory_id");
        this.amount = rs.getDouble("amount");
    }

    @Override
    public TransactionType getType() {
        return TransactionType.SALARY;
    }

    @Override
    public GuiItem getIcon(IconManager iconManager, Player player, LangType langType) {
        return iconManager.get(IconKey.SALARY_TRANSACTION).setName(Lang.SALARY_TRANSACTION_NAME.get(langType, new String[0])).setDescription(Lang.TRANSACTION_FROM.get(this.getTerritoryName(this.territoryID, langType)), Lang.TRANSACTION_TO.get(this.getPlayerName(this.playerID, langType)), Lang.TRANSACTION_AMOUNT.get(Double.toString(this.amount))).asGuiItem(player, langType);
    }

    @Override
    public String getInsertSQL() {
        return "INSERT INTO transaction_salary (timestamp, player_id, territory_id, amount) VALUES (?, ?, ?, ?)";
    }

    @Override
    public void fillInsertStatement(PreparedStatement ps) throws SQLException {
        ps.setLong(1, this.getDate().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        ps.setString(2, this.playerID);
        ps.setString(3, this.territoryID);
        ps.setDouble(4, this.amount);
    }

    @Override
    public Set<String> getConcerned() {
        HashSet<String> res = new HashSet<String>();
        res.add(this.playerID);
        res.add(this.territoryID);
        return res;
    }

    public double getAmount() {
        return this.amount;
    }
}

