/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.database.transactions.instance;

import dev.triumphteam.gui.guis.GuiItem;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.entity.Player;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.database.transactions.AbstractTransaction;
import org.leralix.tan.storage.database.transactions.TransactionType;

public class TerritoryTaxTransaction
extends AbstractTransaction {
    private final String senderID;
    private final String recieverID;
    private final double amount;
    private final boolean enoughMoney;

    public TerritoryTaxTransaction(String senderID, String recieverID, double amount, boolean enoughMoney) {
        this.senderID = senderID;
        this.recieverID = recieverID;
        this.amount = amount;
        this.enoughMoney = enoughMoney;
    }

    public TerritoryTaxTransaction(ResultSet rs) throws SQLException {
        long timestamp = rs.getLong("timestamp");
        this.localDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        this.senderID = rs.getString("sender_id");
        this.recieverID = rs.getString("receiver_id");
        this.amount = rs.getDouble("amount");
        this.enoughMoney = rs.getBoolean("enough_money");
    }

    @Override
    public TransactionType getType() {
        return TransactionType.TERRITORY_TAX;
    }

    @Override
    public GuiItem getIcon(IconManager iconManager, Player player, LangType langType) {
        return iconManager.get(IconKey.TERRITORY_TAX_ICON).setName(Lang.DONATION_TRANSACTION_NAME.get(langType, new String[0])).setDescription(Lang.TRANSACTION_FROM.get(this.getTerritoryName(this.senderID, langType)), Lang.TRANSACTION_TO.get(this.getPlayerName(this.recieverID, langType)), Lang.TRANSACTION_AMOUNT.get(Double.toString(this.amount))).asGuiItem(player, langType);
    }

    @Override
    public String getInsertSQL() {
        return "INSERT INTO transaction_territory_taxes (timestamp, sender_id, receiver_id, amount, enough_money) VALUES (?, ?, ?, ?, ?)";
    }

    @Override
    public void fillInsertStatement(PreparedStatement ps) throws SQLException {
        ps.setLong(1, this.getDate().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        ps.setString(2, this.senderID);
        ps.setString(3, this.recieverID);
        ps.setDouble(4, this.amount);
        ps.setBoolean(5, this.enoughMoney);
    }

    @Override
    public Set<String> getConcerned() {
        HashSet<String> res = new HashSet<String>();
        res.add(this.senderID);
        res.add(this.recieverID);
        return res;
    }

    public String getPlayerID() {
        return this.senderID;
    }

    public String getTownID() {
        return this.recieverID;
    }

    public double getAmount() {
        return this.amount;
    }
}

