/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.database.transactions.instance;

import dev.triumphteam.gui.guis.GuiItem;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Set;
import org.bukkit.entity.Player;
import org.leralix.tan.gui.cosmetic.IconKey;
import org.leralix.tan.gui.cosmetic.IconManager;
import org.leralix.tan.lang.Lang;
import org.leralix.tan.lang.LangType;
import org.leralix.tan.storage.database.transactions.AbstractTransaction;
import org.leralix.tan.storage.database.transactions.TransactionType;

public class UpgradeTransaction
extends AbstractTransaction {
    private final String territoryID;
    private final String upgradeID;
    private final int newLevel;
    private final double amount;

    public UpgradeTransaction(String territoryID, String upgradeID, int newLevel, double amount) {
        this.territoryID = territoryID;
        this.upgradeID = upgradeID;
        this.newLevel = newLevel;
        this.amount = amount;
    }

    public UpgradeTransaction(ResultSet rs) throws SQLException {
        long timestamp = rs.getLong("timestamp");
        this.localDate = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneId.systemDefault());
        this.territoryID = rs.getString("territory_id");
        this.upgradeID = rs.getString("upgrade_id");
        this.newLevel = rs.getInt("upgrade_new_level");
        this.amount = rs.getDouble("amount");
    }

    @Override
    public TransactionType getType() {
        return TransactionType.UPGRADE;
    }

    @Override
    public GuiItem getIcon(IconManager iconManager, Player player, LangType langType) {
        String upgradeName = this.getUpgradeName(this.territoryID, this.upgradeID, langType);
        return iconManager.get(IconKey.UPGRADE_REQUIREMENT).setName(Lang.UPGRADE_TRANSACTION.get(langType, new String[0])).setDescription(Lang.TRANSACTION_FROM.get(this.getTerritoryName(this.territoryID, langType)), Lang.TRANSACTION_UPGRADE.get(upgradeName, Integer.toString(this.newLevel)), Lang.TRANSACTION_AMOUNT.get(Double.toString(this.amount))).asGuiItem(player, langType);
    }

    @Override
    public String getInsertSQL() {
        return "INSERT INTO transaction_upgrades (timestamp, territory_id, upgrade_id, upgrade_new_level, amount) VALUES (?, ?, ?, ?, ?)";
    }

    @Override
    public void fillInsertStatement(PreparedStatement ps) throws SQLException {
        ps.setLong(1, this.getDate().atZone(ZoneId.systemDefault()).toInstant().toEpochMilli());
        ps.setString(2, this.territoryID);
        ps.setString(3, this.upgradeID);
        ps.setInt(4, this.newLevel);
        ps.setDouble(5, this.amount);
    }

    @Override
    public Set<String> getConcerned() {
        return Collections.singleton(this.territoryID);
    }

    public String getTerritoryID() {
        return this.territoryID;
    }

    public String getUpgradeID() {
        return this.upgradeID;
    }

    public int getNewLevel() {
        return this.newLevel;
    }

    public double getAmount() {
        return this.amount;
    }
}

