/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.stored;

import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Location;
import org.leralix.lib.position.Vector3D;
import org.leralix.tan.dataclass.Landmark;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.storage.stored.JsonStorage;
import org.leralix.tan.storage.stored.NewClaimedChunkStorage;

public class LandmarkStorage
extends JsonStorage<Landmark> {
    private int newLandmarkID;
    private static LandmarkStorage instance;

    private LandmarkStorage() {
        super("TAN - Landmarks.json", new TypeToken<HashMap<String, Landmark>>(){}.getType(), new GsonBuilder().setPrettyPrinting().create());
    }

    public static LandmarkStorage getInstance() {
        if (instance == null) {
            instance = new LandmarkStorage();
        }
        return instance;
    }

    public static void setInstance(LandmarkStorage mockLandmarkStorage) {
        instance = mockLandmarkStorage;
    }

    public Landmark addLandmark(Location position) {
        Vector3D vector3D = new Vector3D(position);
        String landmarkID = "L" + this.newLandmarkID;
        Landmark landmark = new Landmark(landmarkID, vector3D);
        this.put(landmarkID, landmark);
        ++this.newLandmarkID;
        NewClaimedChunkStorage.getInstance().claimLandmarkChunk(position.getChunk(), landmarkID);
        this.save();
        return landmark;
    }

    public List<Landmark> getLandmarkOf(TerritoryData territoryData) {
        return this.getAll().values().stream().filter(landmark -> landmark.isOwnedBy(territoryData)).toList();
    }

    public void generateAllResources() {
        for (Landmark landmark : this.getAll().values()) {
            landmark.generateResources();
        }
    }

    @Override
    public void load() {
        super.load();
        int ID = 0;
        for (String ids : this.getAll().keySet()) {
            int newID = Integer.parseInt(ids.substring(1));
            if (newID <= ID) continue;
            ID = newID;
        }
        this.newLandmarkID = ID + 1;
    }

    @Override
    public void reset() {
        instance = null;
    }
}

