/*
 * Decompiled with CFR 0.152.
 */
package org.leralix.tan.storage.stored;

import com.google.common.reflect.TypeToken;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import org.leralix.tan.dataclass.territory.TerritoryData;
import org.leralix.tan.storage.stored.JsonStorage;
import org.leralix.tan.storage.typeadapter.WargoalTypeAdapter;
import org.leralix.tan.war.War;
import org.leralix.tan.war.legacy.wargoals.WarGoal;

public class WarStorage
extends JsonStorage<War> {
    private static WarStorage instance;

    private WarStorage() {
        super("Wars.json", new TypeToken<HashMap<String, War>>(){}.getType(), new GsonBuilder().registerTypeAdapter((Type)((Object)WarGoal.class), new WargoalTypeAdapter()).setPrettyPrinting().create());
    }

    public War newWar(TerritoryData attackingTerritory, TerritoryData defendingTerritory) {
        String newID = this.getNewID();
        War newWar = new War(newID, attackingTerritory, defendingTerritory);
        this.add(newWar);
        return newWar;
    }

    public static WarStorage getInstance() {
        if (instance == null) {
            instance = new WarStorage();
        }
        return instance;
    }

    private void add(War plannedAttack) {
        this.put(plannedAttack.getID(), plannedAttack);
    }

    public void remove(War plannedAttack) {
        this.delete(plannedAttack.getID());
    }

    private String getNewID() {
        int ID = 0;
        while (this.dataMap.containsKey("W" + ID)) {
            ++ID;
        }
        return "W" + ID;
    }

    public void territoryDeleted(TerritoryData territoryData) {
        for (War plannedAttack : this.dataMap.values()) {
            if (!plannedAttack.isMainAttacker(territoryData) && !plannedAttack.isMainDefender(territoryData)) continue;
            plannedAttack.endWar();
        }
    }

    public List<War> getWarsOfTerritory(TerritoryData territoryData) {
        return this.dataMap.values().stream().filter(war -> war.isMainAttacker(territoryData) || war.isMainDefender(territoryData)).toList();
    }

    public boolean isTerritoryAtWarWith(TerritoryData mainTerritory, TerritoryData territoryData) {
        for (War war : this.getWarsOfTerritory(mainTerritory)) {
            if (!war.isMainAttacker(territoryData) && !war.isMainDefender(territoryData)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reset() {
        instance = null;
    }
}

